/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.handlers.impl;

import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.services.handlers.UndeployedProcessHandler;
import org.ow2.orchestra.util.ArchiveTool;
import org.ow2.orchestra.util.EnvTool;

public class ArchiveUndeployedProcessHandler
implements UndeployedProcessHandler {
    public void handleUndeployedProcess(ProcessDefinition processDefinition) {
        Archiver archiver = EnvTool.getArchiver();
        Querier querier = EnvTool.getJournalQueriers();
        Recorder recorder = EnvTool.getRecorder();
        if (querier != null) {
            ProcessFullDefinition processFullDefinition = querier.getProcessDefinition(processDefinition.getUUID());
            ArchiveTool.atomicArchive(processFullDefinition, recorder, archiver);
        }
    }
}

