/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherImpl
implements Publisher {
    private Repository repository = null;

    private synchronized Repository getRepository() {
        if (this.repository == null) {
            this.repository = Environment.getCurrent().get(Repository.class);
        }
        return this.repository;
    }

    @Override
    public void publishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.log(Level.INFO, "Publishing services for Bpel process %s.", bpelProcess.getQName());
        Set<OperationKey> operationKeys = this.getServiceOperationKeys(bpelProcess, bpelProcess.getInitial(), environment);
        for (OperationKey operationKey : operationKeys) {
            Receiver receiver = this.createReceiverInstance(operationKey);
            bpelProcess.addReceiver(receiver);
        }
    }

    protected Set<OperationKey> getServiceOperationKeys(BpelProcess bpelProcess, NodeImpl node, Environment environment) {
        List<Node> children;
        HashSet<OperationKey> operationKeys = new HashSet<OperationKey>();
        Activity behaviour = node.getBehaviour();
        if (behaviour instanceof InboundMessageElement) {
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)behaviour);
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                OperationKey operationKey = receivingElement.getOperationKey();
                operationKeys.add(operationKey);
            }
        }
        if ((children = node.getNodes()) != null) {
            for (Node child : children) {
                operationKeys.addAll(this.getServiceOperationKeys(bpelProcess, (NodeImpl)child, environment));
            }
        }
        return operationKeys;
    }

    @Override
    public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.log(Level.INFO, "Unpublishing services for Bpel process %s.", bpelProcess.getQName());
        this.unpublishServices(bpelProcess, bpelProcess.getInitial(), environment);
    }

    public void unpublishServices(BpelProcess bpelProcess, NodeImpl node, Environment environment) {
        List<Node> children;
        Activity behaviour = node.getBehaviour();
        if (behaviour instanceof InboundMessageElement) {
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)behaviour);
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                OperationKey operationKey = receivingElement.getOperationKey();
                bpelProcess.removeReceiver(operationKey);
            }
        }
        if ((children = node.getNodes()) != null) {
            for (Node child : children) {
                this.unpublishServices(bpelProcess, (NodeImpl)child, environment);
            }
        }
    }

    @Override
    public void republishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.log(Level.INFO, "Republishing services for Bpel process %s.", bpelProcess.getQName());
    }

    protected Receiver createReceiverInstance(OperationKey operationKey) {
        return new Receiver(operationKey);
    }
}

