/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.ow2.orchestra.axis.AxisDeployer;
import org.ow2.orchestra.axis.OrchestraBaseAxisServlet;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.itf.HttpPublisher;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisPublisher
extends PublisherImpl
implements HttpPublisher {
    public void publishServices(BpelProcess bpelProcess, Environment environment) {
        super.publishServices(bpelProcess, environment);
        AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
        List<Service> services = this.getServices(bpelProcess);
        if (services != null) {
            axisDeployer.deploy(services);
        }
    }

    public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
        AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
        List<Service> services = this.getServices(bpelProcess);
        if (services != null) {
            axisDeployer.undeploy(services);
        }
        super.unpublishServices(bpelProcess, environment);
    }

    private List<Service> getServices(BpelProcess bpelProcess) {
        List<OperationKey> opKeys = this.getReceiverOpKeys(bpelProcess, bpelProcess.getInitial(), Environment.getCurrent());
        WsdlsInfos wsdlInfos = bpelProcess.getWsdlInfos();
        ArrayList<Service> services = null;
        ArrayList<QName> missingServices = new ArrayList<QName>();
        for (OperationKey operationKey : opKeys) {
            QName portTypeQName = operationKey.getPortTypeQName();
            List portTypeServices = wsdlInfos.getServicesOfPortType(portTypeQName);
            if (portTypeServices != null) {
                if (services == null) {
                    services = new ArrayList<Service>();
                }
                for (Service service : portTypeServices) {
                    if (services.contains(service)) continue;
                    services.add(service);
                }
                continue;
            }
            missingServices.add(portTypeQName);
        }
        if (!missingServices.isEmpty()) {
            StringBuffer msg = new StringBuffer("Some wsdl services not found for receiving activities. Please specify service for the following PortTypes: ");
            boolean first = true;
            for (QName ptQName : missingServices) {
                msg.append(first ? "" : ", ").append(ptQName.toString());
                first = false;
            }
            msg.append(".");
            throw new OrchestraRuntimeException(msg.toString());
        }
        return services;
    }

    protected List<OperationKey> getReceiverOpKeys(BpelProcess bpelProcess, NodeImpl node, Environment environment) {
        List children;
        ArrayList<OperationKey> opKeys = new ArrayList<OperationKey>();
        Activity behaviour = node.getBehaviour();
        if (behaviour instanceof InboundMessageElement) {
            InboundMessageElement inboundMessageElement = (InboundMessageElement)behaviour;
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                opKeys.add(receivingElement.getOperationKey());
            }
        }
        if ((children = node.getNodes()) != null) {
            for (Node child : children) {
                opKeys.addAll(this.getReceiverOpKeys(bpelProcess, (NodeImpl)child, environment));
            }
        }
        return opKeys;
    }

    public void republishServices(BpelProcess bpelProcess, Environment environment) {
        super.republishServices(bpelProcess, environment);
        AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
        axisDeployer.resetServiceDir();
        List<Service> services = this.getServices(bpelProcess);
        if (services != null) {
            axisDeployer.deploy(services);
        }
    }

    public Servlet getPublisherServlet() {
        return new OrchestraBaseAxisServlet();
    }
}

