/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Date;
import java.util.Map;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.pvm.activity.ActivityExecution;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActivity
implements ExternalActivity {
    private static final long serialVersionUID = -2049270479220106510L;
    protected long dbid;
    protected ActivityDefinitionUUID uuid;
    protected String name = null;

    public long getDbid() {
        return this.dbid;
    }

    public ActivityDefinitionUUID getUuid() {
        return this.uuid;
    }

    public void setUuid(ActivityDefinitionUUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract ActivityType getType();

    public void beforeRunning(BpelExecution bpelExecution) {
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityInstanceUUID(bpelExecution.getProcessInstanceUUID());
        bpelExecution.setStartedDate(new Date());
        bpelExecution.setActivityInstanceUUID(activityInstanceUUID);
        EnvTool.getRecorder().recordActivityStarted(this.createRuntimeData(bpelExecution));
    }

    public ActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.getType(), this.name);
    }

    public final ActivityInstanceData createRuntimeData(BpelExecution bpelExecution) {
        return new ActivityInstanceData(this.createDefinitionData(bpelExecution.getProcessDefinition()), bpelExecution.getProcessInstance().getProcessInstanceData(), bpelExecution.getActivityInstanceUUID(), bpelExecution.getEncloserActivityInstanceUUID());
    }

    public void afterRunned(BpelExecution bpelExecution) {
        EnvTool.getRecorder().recordActivityEnded(this.createRuntimeData(bpelExecution));
    }

    @Override
    public void signal(ActivityExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null || !signal.equals("target")) {
            this.signal((BpelExecution)execution, signal, parameters);
        }
    }

    public abstract void signal(BpelExecution var1, String var2, Map<String, Object> var3);

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractActivity)) {
            return false;
        }
        AbstractActivity other = (AbstractActivity)obj;
        return other.getUuid().equals(this.uuid);
    }
}

