/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ListIterator;
import java.util.Map;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.data.def.CompensateScopeActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensateScope
extends AbstractBpelActivity {
    private static final long serialVersionUID = 5427405633738152258L;
    private String target;

    @Override
    public void executeActivity(BpelExecution execution) {
        BpelExecution callerScopeExecution = this.findCompensateScopeParentScopeExecution(execution);
        BpelExecution scopeExecution = this.findCompensateParentScopeExecution(callerScopeExecution);
        ScopeRuntime sr = scopeExecution.getScopeRuntime();
        if (!sr.getEndedChildren().isEmpty()) {
            ListIterator<ScopeRuntime> srIterator = sr.getEndedChildren().listIterator(sr.getEndedChildren().size());
            while (srIterator.hasPrevious()) {
                ScopeRuntime enclosedScopeRuntime = srIterator.previous();
                NodeImpl enclosedScopeNode = enclosedScopeRuntime.getScopeDefinition().getScopeNode();
                String enclosedScopeName = enclosedScopeRuntime.getScopeDefinition().getName();
                if (!this.target.equals(enclosedScopeName)) continue;
                if (enclosedScopeRuntime.getState().equals((Object)ScopeState.COMPLETED_SUCCESSFUL)) {
                    BpelExecution childExecution = (BpelExecution)scopeExecution.createExecution();
                    childExecution.pushScopeRuntime(enclosedScopeRuntime);
                    childExecution.setActivityInstanceUUID(enclosedScopeRuntime.getActivityInstanceUUID());
                    enclosedScopeRuntime.setCompensateExecution(execution);
                    Node chNode = enclosedScopeNode.getNodes().get(3);
                    childExecution.createExecution().execute(chNode);
                    execution.waitForSignal();
                }
                return;
            }
        }
        throw new OrchestraRuntimeException("The scope \"" + sr.getScopeDefinition().getName() + "\" doesn't have any immediate terminated children called \"" + this.target + "\"");
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        BpelFaultException exception;
        if (parameters != null && (exception = (BpelFaultException)parameters.get("exception")) != null) {
            throw exception;
        }
        this.executeActivity(execution);
    }

    private BpelExecution findCompensateScopeParentScopeExecution(BpelExecution execution) {
        NodeImpl executionNode;
        AbstractActivity executionActivity;
        ActivityType executionActivityType;
        if (execution == null) {
            Misc.unreachableStatement("No parent scope is a fault, termination or compensation handler");
        }
        if ((executionActivityType = (executionActivity = (AbstractActivity)(executionNode = execution.getNode()).getBehaviour()).getType()) == ActivityType.CATCH_HANDLER || executionActivityType == ActivityType.CATCHALL_HANDLER || executionActivityType == ActivityType.TERMINATION_HANDLER || executionActivityType == ActivityType.COMPENSATION_HANDLER) {
            return execution;
        }
        return this.findCompensateScopeParentScopeExecution(execution.getParent());
    }

    private BpelExecution findCompensateParentScopeExecution(BpelExecution execution) {
        ScopeRuntime sr;
        if (execution == null) {
            Misc.unreachableStatement("No scope is currently handling fault, terminating or compensating");
        }
        if ((sr = execution.getScopeRuntime()) != null && (sr.getState().equals((Object)ScopeState.HANDLING_FAULT) || sr.getState().equals((Object)ScopeState.COMPENSATING) || sr.getState().equals((Object)ScopeState.TERMINATING))) {
            return execution;
        }
        return this.findCompensateParentScopeExecution(execution.getParent());
    }

    @Override
    public ActivityType getType() {
        return ActivityType.COMPENSATE_SCOPE;
    }

    @Override
    public CompensateScopeActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new CompensateScopeActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, this.target);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }
}

