/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Map;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatUntil
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    protected Expression condition;

    @Override
    public void executeActivity(BpelExecution execution) {
        NodeImpl node = execution.getNode();
        Node activity = node.getNodes().get(0);
        execution.createExecution().execute(activity);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            NodeImpl node = execution.getNode();
            Node activity = node.getNodes().get(0);
            boolean conditionResult = this.condition.getEvaluator().evaluateBoolean(execution);
            if (conditionResult) {
                execution.end("ended");
                BpelExecution repeatUntilExecution = execution.getParent();
                repeatUntilExecution.removeExecution(execution);
                repeatUntilExecution.signal("finished");
            } else {
                execution.execute(activity);
            }
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.REPEAT_UNTIL;
    }
}

