/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.function;

import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl;
import com.sun.org.apache.xml.internal.dtm.DTM;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DoXslTranformationFunction
implements Function {
    private static final Logger LOG = Logger.getLogger(DoXslTranformationFunction.class.getName());

    public Object call(Context context, List args) throws FunctionCallException {
        Node xpathNodeSet;
        if (args.size() < 2) {
            throw new FunctionCallException("Wrong number of argument for the bpel:doXslTransform function.");
        }
        ContextSupport sup = context.getContextSupport();
        BpelVariableContext variableContext = (BpelVariableContext)sup.getVariableContext();
        Map<String, byte[]> styleSheets = variableContext.getStyleSheets();
        byte[] styleSheetBytes = styleSheets.get(args.get(0));
        if (styleSheetBytes == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.xsltStylesheetNotFound);
        }
        try {
            xpathNodeSet = (Node)args.get(1);
        }
        catch (ClassCastException e) {
            try {
                List nodeList = (List)args.get(1);
                xpathNodeSet = (Node)nodeList.get(0);
            }
            catch (Exception e1) {
                throw new FunctionCallException("The second parameter of bpel:doXslTransform must be a valid Node.");
            }
        }
        StreamSource styleSheet = null;
        try {
            styleSheet = new StreamSource(new ByteArrayInputStream(styleSheetBytes));
            TransformerFactory tFactory = XmlUtil.getTransformerFactory();
            Transformer transformer = tFactory.newTransformer(styleSheet);
            for (int i = 2; i < args.size(); i += 2) {
                Collection parList;
                Object param = args.get(i + 1);
                if (param instanceof Collection && (parList = (Collection)param).size() == 1) {
                    param = parList.iterator().next();
                }
                if (transformer instanceof TransformerImpl && param instanceof Node) {
                    DTM dtm = XSLTCDTMManager.newInstance().getDTM(new DOMSource((Node)param), false, null, false, false);
                    param = dtm;
                }
                transformer.setParameter((String)args.get(i), param);
            }
            Document document = XmlUtil.getNewDocument();
            document.appendChild(document.importNode(xpathNodeSet, true));
            DOMSource source = new DOMSource(document);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document doc = (Document)result.getNode();
            ArrayList<Node> listReturned = new ArrayList<Node>();
            listReturned.add(doc.getFirstChild());
            ArrayList<Node> arrayList = listReturned;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught when doing xsl transformation : ", e);
        }
        finally {
            try {
                styleSheet.getInputStream().close();
            }
            catch (Exception e) {}
        }
    }

    public static Object evaluate(Object variableArg, Object propertyArg, Context context) throws FunctionCallException {
        LOG.finest("parameters: " + variableArg + ", " + propertyArg);
        Navigator nav = context.getNavigator();
        ContextSupport sup = context.getContextSupport();
        String variableName = StringFunction.evaluate(variableArg, nav);
        BpelVariableContext variableContext = (BpelVariableContext)sup.getVariableContext();
        Variable variableDefinition = variableContext.findVariableDefinition(variableName);
        if (variableDefinition == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        String propertyName = StringFunction.evaluate(propertyArg, nav);
        NamespaceContext nsContext = sup.getNamespaceContext();
        QName propertyQName = DoXslTranformationFunction.toQName(propertyName, nsContext);
        Object propertyValue = variableContext.getPropertyValue(variableName, propertyQName);
        LOG.finest("return value: " + propertyValue);
        return propertyValue;
    }

    private static QName toQName(String prefixedName, NamespaceContext namespaceContext) {
        int colonIndex = prefixedName.indexOf(58);
        if (colonIndex == -1) {
            return new QName(prefixedName);
        }
        String localName = prefixedName.substring(colonIndex + 1);
        String prefix = prefixedName.substring(0, colonIndex);
        String namespaceURI = namespaceContext.translateNamespacePrefixToUri(prefix);
        return new QName(namespaceURI, localName, prefix);
    }
}

