/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.function;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;

public class GetVariablePropertyFunction
implements Function {
    private static final Logger LOG = Logger.getLogger(GetVariablePropertyFunction.class.getName());

    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() != 2) {
            throw new FunctionCallException("getVariableProperty() requires two arguments");
        }
        return GetVariablePropertyFunction.evaluate(args.get(0), args.get(1), context);
    }

    public static Object evaluate(Object variableArg, Object propertyArg, Context context) throws FunctionCallException {
        LOG.finest("parameters: " + variableArg + ", " + propertyArg);
        Navigator nav = context.getNavigator();
        ContextSupport sup = context.getContextSupport();
        String variableName = StringFunction.evaluate(variableArg, nav);
        BpelVariableContext variableContext = (BpelVariableContext)sup.getVariableContext();
        Variable variableDefinition = variableContext.findVariableDefinition(variableName);
        if (variableDefinition == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        String propertyName = StringFunction.evaluate(propertyArg, nav);
        NamespaceContext nsContext = sup.getNamespaceContext();
        QName propertyQName = GetVariablePropertyFunction.toQName(propertyName, nsContext);
        Object propertyValue = variableContext.getPropertyValue(variableName, propertyQName);
        LOG.finest("return value: " + propertyValue);
        return propertyValue;
    }

    private static QName toQName(String prefixedName, NamespaceContext namespaceContext) {
        int colonIndex = prefixedName.indexOf(58);
        if (colonIndex == -1) {
            return new QName(prefixedName);
        }
        String localName = prefixedName.substring(colonIndex + 1);
        String prefix = prefixedName.substring(0, colonIndex);
        String namespaceURI = namespaceContext.translateNamespacePrefixToUri(prefix);
        return new QName(namespaceURI, localName, prefix);
    }
}

