/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.If;
import org.ow2.orchestra.definition.element.Else;
import org.ow2.orchestra.definition.element.Elseif;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.IfActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ElseFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.ElseIfFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.IfActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(IfBinding.class.getName());

    public IfBinding() {
        super("if", ActivityType.IF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        If ifObject = new If();
        NodeImpl ifNode = this.createActivityNode(element, parse, parser, (ExternalActivity)ifObject);
        this.setEnclosingScope(ifObject, parse);
        this.parseStandardAttributes(element, ifObject, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        IfActivityFullDefinition ifActivityFullDefinition = (IfActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        this.parseStandardElements(element, ifObject, parse);
        parse.pushObject(ifNode);
        parse.pushObject(ifObject);
        try {
            Expression expression = this.parseCondition(element, parse);
            ifObject.setCondition(expression);
            NodeImpl nodeImpl = this.parseChildActivity(element, parse, parser);
            ifObject.setActivity(nodeImpl);
            ifActivityFullDefinition.setExpression(expression.getText());
            ifActivityFullDefinition.setExpressionLanguage(expression.getLanguage());
            List<Element> elseifElements = XmlUtil.elements(element, "elseif");
            this.parseElseifs(elseifElements, ifObject, parse, parser, ifActivityFullDefinition);
            Element elseElement = XmlUtil.element(element, "else");
            this.parseElse(elseElement, ifObject, parse, parser, ifActivityFullDefinition);
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        return ifNode;
    }

    private void parseElseifs(List<Element> elseifElements, If ifObject, Parse parse, Parser parser, IfActivityFullDefinition ifActivityFullDefinition) {
        ArrayList<Elseif> elseifs = new ArrayList<Elseif>();
        if (elseifElements != null) {
            for (Element elseifElement : elseifElements) {
                ElseIfFullDefinitionImpl elseIfFullDefinition = new ElseIfFullDefinitionImpl();
                DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
                defKeeper.pushParent(elseIfFullDefinition);
                Elseif elseif = this.parseElseif(elseifElement, parse, parser);
                elseifs.add(elseif);
                elseIfFullDefinition.setExpression(elseif.getCondition().getText());
                elseIfFullDefinition.setExpressionLanguage(elseif.getCondition().getLanguage());
                ifActivityFullDefinition.addElseIfFullDefinition(elseIfFullDefinition);
                defKeeper.popParent();
            }
        }
        ifObject.setElseifs(elseifs);
    }

    private Elseif parseElseif(Element elseifElement, Parse parse, Parser parser) {
        Elseif elseif = new Elseif();
        elseif.setCondition(this.parseCondition(elseifElement, parse));
        elseif.setActivity(this.parseChildActivity(elseifElement, parse, parser));
        return elseif;
    }

    private void parseElse(Element elseElement, If ifObject, Parse parse, Parser parser, IfActivityFullDefinition ifActivityFullDefinition) {
        if (elseElement != null) {
            ElseFullDefinitionImpl elseFullDefinition = new ElseFullDefinitionImpl();
            DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
            defKeeper.pushParent(elseFullDefinition);
            Else else1 = new Else();
            else1.setActivity(this.parseChildActivity(elseElement, parse, parser));
            ifObject.setElse(else1);
            ifActivityFullDefinition.setElseFullDefinition(elseFullDefinition);
            defKeeper.popParent();
        }
    }

    private Expression parseCondition(Element parentElement, Parse parse) {
        Element conditionElement = XmlUtil.element(parentElement, "condition");
        if (conditionElement != null) {
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            String expressionLanguage = XmlUtil.attribute(conditionElement, "expressionLanguage");
            if (expressionLanguage == null) {
                expressionLanguage = bpelProcess.getExpressionLanguage();
            }
            Expression expression = new Expression();
            expression.setLanguage(expressionLanguage);
            expression.setNamespaces(BpelUtil.getAllNameSpaces(conditionElement));
            expression.setText(conditionElement.getTextContent());
            return expression;
        }
        return null;
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new IfActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

