/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.deploy;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.ProcessDefinition;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.log.Log;

public class CreateProcess
implements Deployer {
    private static final Log LOG = Log.getLog(CreateProcess.class.getName());
    protected Class<?> processDefinitionClass;

    public void deploy(Deployment deployment) {
        ProcessDefinition processDefinition = deployment.getProcessDefinition();
        if (processDefinition == null) {
            if (this.processDefinitionClass == null) {
                throw new PvmException("create-process deployer improperly configured: no class specified");
            }
            try {
                LOG.trace("creating new " + this.processDefinitionClass.getName());
                processDefinition = (ProcessDefinition)this.processDefinitionClass.newInstance();
            }
            catch (Exception e) {
                throw new PvmException("couldn't instantiate process definition with class " + this.processDefinitionClass);
            }
            deployment.setProcessDefinition(processDefinition);
        } else {
            LOG.trace("using process definition provided in deployment");
        }
    }
}

