/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cal.BusinessCalendar;
import org.ow2.orchestra.pvm.internal.cal.Duration;
import org.ow2.orchestra.pvm.internal.env.JobContext;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.util.Clock;
import org.ow2.orchestra.pvm.job.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerImpl
extends JobImpl<Boolean>
implements Timer {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(TimerImpl.class.getName());
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
    protected String signalName;
    protected String eventName;
    protected String repeat;
    public static final String EVENT_TIMER = "timer";

    public void setDueDateDescription(String dueDateDescription) {
        Duration duration = new Duration(dueDateDescription);
        Date now = this.getDueDate();
        if (duration.isBusinessTime() || duration.getMonths() > 0 || duration.getYears() > 0) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new PvmException("no environment to get business calendar for calculating dueDate " + dueDateDescription);
            }
            BusinessCalendar businessCalendar = environment.get(BusinessCalendar.class);
            this.dueDate = businessCalendar.add(now, duration);
        } else {
            long millis = duration.getMillis() + 1000 * (duration.getSeconds() + 60 * (duration.getMinutes() + 60 * (duration.getHours() + 24 * (duration.getDays() + 7 * duration.getWeeks()))));
            this.dueDate = new Date(now.getTime() + millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(Environment environment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("executing " + this);
        }
        if (environment == null) {
            throw new PvmException("environment is null");
        }
        JobContext jobContext = new JobContext(this);
        environment.addContext(jobContext);
        try {
            if (this.signalName != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("feeding timer signal " + this.signalName + " into " + this.execution);
                }
                this.execution.signal(this.signalName);
            }
            if (this.eventName != null) {
                NodeImpl eventSource = this.execution.getNode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("firing event " + this.signalName + " into " + eventSource);
                }
                this.execution.fire(this.eventName, eventSource);
            }
        }
        finally {
            environment.removeContext(jobContext);
        }
        boolean deleteThisJob = true;
        if (this.repeat == null) {
            JobDbSession dbSession;
            if (LOG.isDebugEnabled()) {
                LOG.debug("deleting " + this);
            }
            if ((dbSession = environment.get(JobDbSession.class)) == null) {
                throw new PvmException("no " + JobDbSession.class.getName() + " in environment");
            }
            dbSession.delete(this);
        } else {
            deleteThisJob = false;
            do {
                this.setDueDateDescription(this.repeat);
            } while (this.dueDate.getTime() <= Clock.getCurrentTime().getTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("rescheduled " + this + " for " + TimerImpl.formatDueDate(this.dueDate));
            }
            this.setLockOwner(null);
            this.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (jobExecutor != null) {
                Transaction transaction = environment.get(Transaction.class);
                if (transaction == null) {
                    throw new PvmException("no transaction in environment");
                }
                JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor);
                transaction.registerSynchronization(jobNotificator);
            }
        }
        return deleteThisJob;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("timer[");
        buffer.append(this.dbid);
        if (this.dueDate != null) {
            buffer.append("|");
            buffer.append(TimerImpl.formatDueDate(this.dueDate));
        }
        if (this.signalName != null) {
            buffer.append("|");
            buffer.append(this.signalName);
        }
        if (this.eventName != null) {
            buffer.append("|");
            buffer.append(this.eventName);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String formatDueDate(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    @Override
    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }
}

