/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.Date;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcherThread
extends Thread {
    private boolean isActive = true;
    private boolean checkForNewJobs;
    private int currentIdleInterval;
    private final Object semaphore = new Object();
    private static final Log LOG = Log.getLog(AbstractDispatcherThread.class.getName());

    public AbstractDispatcherThread() {
    }

    public AbstractDispatcherThread(Runnable target) {
        super(target);
    }

    public AbstractDispatcherThread(String name) {
        super(name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    protected abstract void putAcquiredJobDbidsOnQueue(Collection<Long> var1);

    public AbstractDispatcherThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public AbstractDispatcherThread(Runnable target, String name) {
        super(target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public AbstractDispatcherThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            LOG.info("starting...");
            this.currentIdleInterval = this.getJobExecutor().getIdleMillis();
            block16: while (true) {
                try {
                    while (this.isActive) {
                        try {
                            long waitPeriod;
                            this.checkForNewJobs = false;
                            Collection<Long> acquiredJobDbids = this.acquireJobs();
                            this.currentIdleInterval = this.getJobExecutor().getIdleMillis();
                            if (acquiredJobDbids != null && !acquiredJobDbids.isEmpty()) {
                                this.putAcquiredJobDbidsOnQueue(acquiredJobDbids);
                                LOG.info("added jobs " + acquiredJobDbids + " to the queue");
                                continue block16;
                            }
                            if (!this.isActive || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block16;
                            Object object = this.semaphore;
                            synchronized (object) {
                                if (!this.checkForNewJobs) {
                                    LOG.debug(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.getJobExecutor());
                                    this.semaphore.wait(waitPeriod);
                                    LOG.debug(this.getName() + " woke up");
                                } else {
                                    LOG.debug("skipped wait because new message arrived");
                                }
                                continue block16;
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.info((this.isActive ? "active" : "inactivated") + " jobImpl dispatcher thread '" + this.getName() + "' got interrupted");
                        }
                        catch (Exception e) {
                            LOG.error("exception in jobImpl executor thread. waiting " + this.currentIdleInterval + " milliseconds", e);
                            try {
                                Object waitPeriod = this.semaphore;
                                synchronized (waitPeriod) {
                                    this.semaphore.wait(this.currentIdleInterval);
                                }
                            }
                            catch (InterruptedException e2) {
                                LOG.trace("delay after exception got interrupted", e2);
                            }
                            this.currentIdleInterval *= 2;
                        }
                    }
                    break block22;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    break block22;
                }
            }
            finally {
                LOG.info(this.getName() + " leaves cyberspace");
            }
        }
    }

    protected Collection<Long> acquireJobs() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Collection<Long>> acquireJobsCommand = this.getJobExecutor().getAcquireJobsCommand();
        return commandService.execute(acquireJobsCommand);
    }

    protected Date getNextDueDate() {
        CommandService commandService = this.getJobExecutor().getCommandExecutor();
        Command<Date> getNextDueDate = this.getJobExecutor().getNextDueDateCommand();
        return commandService.execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.getJobExecutor().getIdleMillis();
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            LOG.debug("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                while (this.isAlive()) {
                    try {
                        LOG.debug("joining " + this.getName());
                        this.join();
                    }
                    catch (InterruptedException e) {
                        LOG.trace("joining " + this.getName() + " got interrupted");
                    }
                }
            }
        } else {
            LOG.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        LOG.trace("notifying jobImpl executor dispatcher thread of new jobImpl");
        Object object = this.semaphore;
        synchronized (object) {
            this.checkForNewJobs = true;
            this.semaphore.notify();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public abstract AbstractJobExecutor getJobExecutor();
}

