/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.jdk;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.GetNextDueDateCmd;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.jdk.JdkDispatcherThread;
import org.ow2.orchestra.pvm.internal.log.Log;

public class JdkJobExecutor
extends AbstractJobExecutor
implements JobExecutor {
    private static final Log LOG = Log.getLog(JdkJobExecutor.class.getName());
    private ExecutorService executorService;
    private JdkDispatcherThread dispatcherThread = null;

    public synchronized void start() {
        if (this.commandService == null) {
            throw new PvmException("no command executor available in jobImpl executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this.getName(), this.getLockMillis());
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.isActive = true;
            LOG.trace("starting jobImpl executor threads for jobImpl executor '" + this.name + "'...");
            this.executorService = Executors.newCachedThreadPool();
            LOG.trace("starting dispatcher thread for jobImpl executor '" + this.name + "'...");
            this.dispatcherThread = new JdkDispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            LOG.trace("ignoring start: jobImpl executor '" + this.name + "' is already started'");
        }
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        LOG.debug("stopping jobImpl executor");
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.executorService.shutdown();
            if (join) {
                this.waitTillQueueEmpty();
            }
        } else {
            LOG.trace("ignoring stop: jobImpl executor '" + this.name + "' not started");
        }
    }

    protected void waitTillQueueEmpty() {
        while (!this.executorService.isTerminated()) {
            LOG.trace("waiting for jobImpl-id-queue to become empty");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.trace("waiting for jobImpl-id-queue to become empty got interrupted");
            }
        }
    }

    public JdkDispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

