/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.util.Clock;
import org.ow2.orchestra.pvm.internal.util.EqualsUtil;
import org.ow2.orchestra.pvm.model.Comment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentImpl
implements Serializable,
Comment {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String userId = null;
    protected Date time = null;
    protected String message = null;
    protected CommentImpl parent;
    protected List<CommentImpl> comments = null;

    public CommentImpl() {
    }

    public CommentImpl(String message) {
        this.message = message;
        this.time = Clock.getCurrentTime();
        Environment environment = Environment.getCurrent();
        if (environment != null) {
            this.userId = environment.getUserId();
        }
    }

    @Override
    public Comment createComment(String message) {
        if (message == null) {
            throw new PvmException("message is null");
        }
        if (this.comments == null) {
            this.comments = new ArrayList<CommentImpl>();
        }
        CommentImpl reply = new CommentImpl(message);
        this.comments.add(reply);
        return reply;
    }

    @Override
    public void removeComment(Comment comment) {
        if (comment == null) {
            throw new PvmException("reply is null");
        }
        if (this.comments != null && this.comments.remove(comment)) {
            ((CommentImpl)comment).setParent(null);
        }
    }

    public Comment getParent() {
        return this.parent;
    }

    public void setParent(CommentImpl parent) {
        this.parent = parent;
    }

    @Override
    public List<Comment> getComments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return this.comments;
    }

    public void setComments(List<CommentImpl> replies) {
        this.comments = replies;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public long getDbid() {
        return this.dbid;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

