/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model.op;

import java.util.LinkedList;
import java.util.List;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ObservableElementImpl;
import org.ow2.orchestra.pvm.internal.model.op.AtomicOperation;
import org.ow2.orchestra.pvm.internal.model.op.ProceedToDestinationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProceedToDestination
implements AtomicOperation {
    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return false;
    }

    @Override
    public void perform(ExecutionImpl execution) {
        NodeImpl destination = execution.getTransition().getDestination();
        execution.setNode(destination);
        List<NodeImpl> enteredNodes = this.getNodesEntered(execution.getTransitionOrigin(), destination);
        ExecutionImpl propagatingExecution = execution;
        for (NodeImpl enteredNode : enteredNodes) {
            propagatingExecution = propagatingExecution.beginNode(enteredNode);
        }
        propagatingExecution.setNode(execution.getTransitionOrigin());
        propagatingExecution.moveTo(destination);
        propagatingExecution.performAtomicOperation(ExecutionImpl.EXECUTE_NODE);
    }

    public List<NodeImpl> getNodesEntered(NodeImpl origin, NodeImpl destination) {
        LinkedList<NodeImpl> nodesEntered = new LinkedList<NodeImpl>();
        if (origin.equals(destination)) {
            nodesEntered.add(destination);
        } else {
            List<ObservableElementImpl> sourceChain = origin.getParentChain();
            if (!sourceChain.contains(destination)) {
                for (NodeImpl destinationNode = destination; destinationNode != null && !sourceChain.contains(destinationNode); destinationNode = destinationNode.getParentNode()) {
                    nodesEntered.addFirst(destinationNode);
                }
            }
        }
        return nodesEntered;
    }

    public String toString() {
        return "proceed-to-destination";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new ProceedToDestinationMessage(execution);
    }
}

