/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.svc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.ExecutionService;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.cmd.FindExecutionCmd;
import org.ow2.orchestra.pvm.internal.cmd.GetVariablesCmd;
import org.ow2.orchestra.pvm.internal.cmd.SetVariablesCmd;
import org.ow2.orchestra.pvm.internal.cmd.SignalCmd;
import org.ow2.orchestra.pvm.internal.cmd.StartExecutionCmd;
import org.ow2.orchestra.pvm.internal.cmd.StartExecutionInLatestCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutionService
implements ExecutionService {
    protected CommandService commandService;

    @Override
    public Execution startExecution(String processDefinitionId) {
        return this.commandService.execute(new StartExecutionCmd(processDefinitionId, null, null));
    }

    @Override
    public Execution startExecution(String processDefinitionId, String executionKey) {
        return this.commandService.execute(new StartExecutionCmd(processDefinitionId, null, executionKey));
    }

    @Override
    public Execution startExecution(String processDefinitionId, Map<String, Object> variables) {
        return this.commandService.execute(new StartExecutionCmd(processDefinitionId, variables, null));
    }

    @Override
    public Execution startExecution(String processDefinitionId, Map<String, Object> variables, String executionKey) {
        return this.commandService.execute(new StartExecutionCmd(processDefinitionId, variables, executionKey));
    }

    @Override
    public Execution startExecutionInLatest(String processDefinitionName) {
        return this.commandService.execute(new StartExecutionInLatestCmd(processDefinitionName, null, null));
    }

    @Override
    public Execution startExecutionInLatest(String processDefinitionName, Map<String, Object> variables) {
        return this.commandService.execute(new StartExecutionInLatestCmd(processDefinitionName, variables, null));
    }

    @Override
    public Execution startExecutionInLatest(String processDefinitionName, String executionKey) {
        return this.commandService.execute(new StartExecutionInLatestCmd(processDefinitionName, null, executionKey));
    }

    @Override
    public Execution startExecutionInLatest(String processDefinitionName, Map<String, Object> variables, String executionKey) {
        return this.commandService.execute(new StartExecutionInLatestCmd(processDefinitionName, variables, executionKey));
    }

    @Override
    public Execution signalExecution(String executionId) {
        return this.commandService.execute(new SignalCmd(executionId, null, null));
    }

    @Override
    public Execution signalExecution(String executionId, String signalName) {
        return this.commandService.execute(new SignalCmd(executionId, signalName, null));
    }

    @Override
    public Execution signalExecution(String executionId, String signalName, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(executionId, signalName, parameters));
    }

    @Override
    public Execution signalExecution(String executionId, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(executionId, null, parameters));
    }

    public Execution signalExecution(long executionDbid) {
        return this.commandService.execute(new SignalCmd(executionDbid, null, null));
    }

    public Execution signalExecution(long executionDbid, String signalName) {
        return this.commandService.execute(new SignalCmd(executionDbid, signalName, null));
    }

    public Execution signalExecution(long executionDbid, String signalName, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(executionDbid, signalName, parameters));
    }

    public Execution signalExecution(long executionDbid, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(executionDbid, null, parameters));
    }

    @Override
    public Execution signalExecutionByKey(String processDefinitionName, String executionKey) {
        return this.commandService.execute(new SignalCmd(processDefinitionName, executionKey, null, null));
    }

    @Override
    public Execution signalExecutionByKey(String processDefinitionName, String executionKey, String signalName) {
        return this.commandService.execute(new SignalCmd(processDefinitionName, executionKey, signalName, null));
    }

    @Override
    public Execution signalExecutionByKey(String processDefinitionName, String executionKey, String signalName, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(processDefinitionName, executionKey, signalName, parameters));
    }

    @Override
    public Execution signalExecutionByKey(String processDefinitionName, String executionKey, Map<String, Object> parameters) {
        return this.commandService.execute(new SignalCmd(processDefinitionName, executionKey, null, parameters));
    }

    @Override
    public Execution findExecution(String processDefinitionName, String key) {
        return this.commandService.execute(new FindExecutionCmd(processDefinitionName, key));
    }

    @Override
    public Execution findExecution(String executionId) {
        return this.commandService.execute(new FindExecutionCmd(executionId));
    }

    @Override
    public Object getVariable(String executionId, String variableName) {
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add(variableName);
        Map<String, Object> variables = this.commandService.execute(new GetVariablesCmd(executionId, variableNames));
        return variables.get(variableName);
    }

    @Override
    public Map<String, Object> getVariables(String executionId, List<String> variableNames) {
        return this.commandService.execute(new GetVariablesCmd(executionId, variableNames));
    }

    @Override
    public Execution setVariable(String executionId, String name, Object value) {
        SetVariablesCmd cmd = new SetVariablesCmd(executionId);
        cmd.addVariable(name, value);
        return this.commandService.execute(cmd);
    }

    @Override
    public Execution setVariables(String executionId, Map<String, Object> variables) {
        SetVariablesCmd cmd = new SetVariablesCmd(executionId);
        cmd.setVariables(variables);
        return this.commandService.execute(cmd);
    }
}

