/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.util;

import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public abstract class PvmXmlUtil {
    private PvmXmlUtil() {
    }

    public static String attribute(Element element, String attributeName, boolean required, Parse parse) {
        if (element.hasAttribute(attributeName)) {
            String value = element.getAttribute(attributeName);
            if (required && "".equals(value)) {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"\" is empty");
            }
            return value;
        }
        if (required) {
            parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"...\" is required");
        }
        return null;
    }

    public static Integer attributeInteger(Element element, String attributeName, boolean required, Parse parse) {
        String valueText = PvmXmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException e) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not parsable as integer"));
            }
        }
        return null;
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse) {
        return PvmXmlUtil.attributeBoolean(element, attributeName, required, parse, null);
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse, Boolean defaultValue) {
        String valueText = PvmXmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            Boolean value = XmlUtil.parseBooleanValue(valueText);
            if (value == null) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not in {true, enabled, on, false, disabled, off}"));
            }
            return value;
        }
        return defaultValue;
    }
}

