/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private String text;

    @Override
    public Object construct(WireContext wireContext) {
        ClassLoader classLoader = wireContext.getClassLoader();
        try {
            return ReflectUtil.loadClass(classLoader, this.text);
        }
        catch (PvmException e) {
            Throwable cause = e.getCause();
            throw new WireException("couldn't load class '" + this.text + "': " + cause.getMessage(), cause);
        }
    }

    public void setClassName(String className) {
        this.text = className;
    }

    public void setClass(Class<?> clazz) {
        this.text = clazz == null ? null : clazz.getName();
    }
}

