/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDescriptor
extends AbstractDescriptor
implements Descriptor {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(CollectionDescriptor.class.getName());
    protected String className;
    protected List<Descriptor> valueDescriptors;
    protected boolean isSynchronized;

    protected CollectionDescriptor() {
    }

    public CollectionDescriptor(String defaultImplClassName) {
        this.className = defaultImplClassName;
    }

    @Override
    public Object construct(WireContext wireContext) {
        Collection object = null;
        try {
            ClassLoader classLoader = wireContext.getClassLoader();
            Class<?> clazz = ReflectUtil.loadClass(classLoader, this.className);
            object = (Collection)clazz.newInstance();
            if (this.isSynchronized) {
                if (object instanceof SortedSet) {
                    object = Collections.synchronizedSortedSet((SortedSet)object);
                } else if (object instanceof SortedMap) {
                    object = Collections.synchronizedSortedMap((SortedMap)((Object)object));
                } else if (object instanceof Set) {
                    object = Collections.synchronizedSet((Set)object);
                } else if (object instanceof Map) {
                    object = Collections.synchronizedMap((Map)((Object)object));
                } else if (object instanceof List) {
                    object = Collections.synchronizedList(object);
                } else if (object instanceof Collection) {
                    object = Collections.synchronizedCollection(object);
                }
            }
        }
        catch (Exception e) {
            throw new WireException("couldn't create '" + (this.name != null ? this.name : this.className) + "': " + e.getMessage(), e);
        }
        return object;
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Collection collection = (Collection)object;
        try {
            if (this.valueDescriptors != null) {
                for (Descriptor descriptor : this.valueDescriptors) {
                    Object element = wireContext.create(descriptor, true);
                    log.trace("adding element " + element + " to collection");
                    collection.add(element);
                }
            }
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WireException("couldn't initialize object '" + (this.name != null ? this.name : this.className) + "'", e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<Descriptor> getValueDescriptors() {
        return this.valueDescriptors;
    }

    public void setValueDescriptors(List<Descriptor> valueDescriptors) {
        this.valueDescriptors = valueDescriptors;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }
}

