/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.wsdl.Definition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.services.job.ExecuteInvokeJob;
import org.ow2.orchestra.services.job.SignalInvokeJob;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeExecutor {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private static Logger LOG = Logger.getLogger(InvokeExecutor.class.getName());

    private InvokeExecutor() {
    }

    public static void executeInvoke(Environment environment, final BpelExecution execution, final OperationKey operationKey, final Element partnerEndPointReference, final MessageVariable requestMessage, final Set<Definition> wsdlDefinitions) {
        final Invoker invoker = EnvTool.get(Invoker.class, "serviceInvoker");
        final CommandService commandService = environment.get(CommandService.class);
        Transaction transaction = environment.get(Transaction.class);
        if (transaction == null) {
            executorService.execute(new InvokeCall(execution, invoker, operationKey, partnerEndPointReference, requestMessage, wsdlDefinitions, commandService));
        } else {
            transaction.registerSynchronization(new Synchronization(){

                public void afterCompletion(int status) {
                    if (status == 3) {
                        executorService.execute(new InvokeCall(execution, invoker, operationKey, partnerEndPointReference, requestMessage, wsdlDefinitions, commandService));
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FinishInvokeCommand
    implements Command<Void> {
        private final BpelExecution execution;
        private final MessageVariable responseMessage;
        private final Exception exception;

        public FinishInvokeCommand(BpelExecution execution, MessageVariable responseMessage) {
            this.execution = execution;
            this.responseMessage = responseMessage;
            this.exception = null;
        }

        public FinishInvokeCommand(BpelExecution execution, Exception exception) {
            this.execution = execution;
            this.responseMessage = null;
            this.exception = exception;
        }

        @Override
        public Void execute(Environment environment) {
            BpelExecution bpelExecution = EnvTool.getRepository().getUpdatedExecution(this.execution);
            if (bpelExecution == null) {
                LOG.info("Invoke response not delivered to execution " + this.execution.getId() + ": execution has been removed.");
                return null;
            }
            if (bpelExecution.isFinished()) {
                LOG.info("Invoke response not delivered to execution " + bpelExecution + ": execution is finished.");
                return null;
            }
            ExecuteInvokeJob invokeJob = null;
            for (Job job : bpelExecution.getJobs()) {
                if (!(job instanceof ExecuteInvokeJob)) continue;
                invokeJob = (ExecuteInvokeJob)job;
                break;
            }
            if (invokeJob == null) {
                Misc.unreachableStatement("unable to find invoke job");
                return null;
            }
            if (this.exception == null || this.exception instanceof BpelFaultException) {
                LOG.info("Deliver invoke response to execution " + bpelExecution);
                boolean isSuspended = invokeJob.isSuspended();
                bpelExecution.getJobs().remove(invokeJob);
                SignalInvokeJob signalInvokeJob = new SignalInvokeJob(this.responseMessage, this.exception);
                signalInvokeJob.setExecution(bpelExecution);
                signalInvokeJob.setSuspended(isSuspended);
                environment.get(MessageSession.class).send(signalInvokeJob);
            } else {
                JobExceptionHandler jobExceptionHandler = new JobExceptionHandler(invokeJob, (Throwable)this.exception);
                jobExceptionHandler.execute(environment);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeCall
    implements Runnable {
        private final Invoker invoker;
        private final OperationKey operationKey;
        private final Element partnerEndPointReference;
        private final MessageVariable requestMessage;
        private final BpelExecution execution;
        private final CommandService commandService;
        private final Set<Definition> wsdlDefinitions;

        public InvokeCall(BpelExecution execution, Invoker invoker, OperationKey operationKey, Element partnerEndPointReference, MessageVariable requestMessage, Set<Definition> wsdlDefinitions, CommandService commandService) {
            this.execution = execution;
            this.invoker = invoker;
            this.operationKey = operationKey;
            this.partnerEndPointReference = partnerEndPointReference;
            this.requestMessage = requestMessage;
            this.wsdlDefinitions = wsdlDefinitions;
            this.commandService = commandService;
        }

        @Override
        public void run() {
            try {
                MessageVariable responseMsg = this.invoker.invoke(this.operationKey, this.partnerEndPointReference, this.requestMessage, this.wsdlDefinitions);
                this.commandService.execute(new FinishInvokeCommand(this.execution, responseMsg));
            }
            catch (Exception e) {
                this.commandService.execute(new FinishInvokeCommand(this.execution, e));
            }
        }
    }
}

