/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.Receive;
import org.ow2.orchestra.definition.element.OnMessage;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.itf.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbRepository
implements Repository {
    @Override
    public long getNextProcessCount() {
        ProcessDeploymentCounter processDeploymentCounter = this.getBpelPersistenceService().getProcessDeploymentCounter();
        if (processDeploymentCounter == null) {
            processDeploymentCounter = new ProcessDeploymentCounter();
            this.getBpelPersistenceService().save(processDeploymentCounter);
        }
        return processDeploymentCounter.getAndIncrementProcessCounter();
    }

    @Override
    public BpelProcess getProcess(QName processQName) {
        return this.getBpelPersistenceService().findBpelProcess(processQName.getNamespaceURI(), processQName.getLocalPart());
    }

    @Override
    public BpelProcess getProcess(ProcessDefinitionUUID processUUID) {
        return this.getBpelPersistenceService().getBpelProcess(processUUID);
    }

    @Override
    public List<BpelProcess> getProcesses() {
        return this.getBpelPersistenceService().getBpelProcesses();
    }

    @Override
    public BpelProcess removeProcess(QName processQName) {
        BpelProcess process = this.getBpelPersistenceService().findBpelProcess(processQName.getNamespaceURI(), processQName.getLocalPart());
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
        }
        return process;
    }

    @Override
    public BpelProcess removeProcess(ProcessDefinitionUUID pduuid) {
        BpelProcess process = this.getBpelPersistenceService().getBpelProcess(pduuid);
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
        }
        return process;
    }

    @Override
    public void storeProcess(BpelProcess process) {
        this.getBpelPersistenceService().save(process);
    }

    @Override
    public BpelProcess lockProcess(ProcessDefinitionUUID processUUID) {
        return this.getBpelPersistenceService().findBpelProcess(processUUID, true);
    }

    @Override
    public BpelExecution getInstance(ProcessInstanceUUID processInstanceUUID) {
        return this.getBpelPersistenceService().getBpelInstance(processInstanceUUID);
    }

    @Override
    public List<BpelExecution> getInstances() {
        return this.getBpelPersistenceService().getBpelInstances();
    }

    @Override
    public List<BpelExecution> getInstances(QName processQName) {
        return this.getBpelPersistenceService().getBpelInstances(processQName);
    }

    @Override
    public void removeInstance(BpelExecution instance) {
        this.removeInstance(instance, false);
    }

    @Override
    public void removeInstance(BpelExecution instance, boolean force) {
        if (force && instance != null && (instance.getProcessInstanceState().equals((Object)ActivityState.RUNNING) || instance.getProcessInstanceState().equals((Object)ActivityState.SUSPENDED))) {
            instance.exit();
        }
        if (instance != null) {
            this.getBpelPersistenceService().delete(instance.getProcessInstance());
        }
    }

    @Override
    public void storeInstance(BpelExecution instance) {
        this.getBpelPersistenceService().save(instance.getProcessInstance());
    }

    @Override
    public BpelExecution getUpdatedExecution(BpelExecution execution) {
        return this.getBpelPersistenceService().get(BpelExecution.class, execution.getDbid());
    }

    @Override
    public PendingMessage getUpdatedPendingMessage(PendingMessage pendingMessage) {
        return this.getBpelPersistenceService().get(PendingMessage.class, pendingMessage.getDbid());
    }

    @Override
    public ReceivingElement getUpdatedReceivingElement(ReceivingElement receivingElement) {
        if (receivingElement instanceof Receive) {
            return this.getBpelPersistenceService().get(Receive.class, ((Receive)receivingElement).getDbid());
        }
        if (receivingElement instanceof OnMessage) {
            return this.getBpelPersistenceService().get(OnMessage.class, ((OnMessage)receivingElement).getDbid());
        }
        return receivingElement;
    }

    @Override
    public List<Job> findJobsWithException() {
        return this.getBpelPersistenceService().findJobsWithException();
    }

    @Override
    public JobImpl<?> getJob(long jobId) {
        return this.getBpelPersistenceService().get(JobImpl.class, jobId);
    }

    private RuntimeDbSession getBpelPersistenceService() {
        return Environment.getCurrent().get(RuntimeDbSession.class);
    }
}

