/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.var;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.facade.runtime.impl.MessageImpl;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageVariable
implements Message {
    protected Map<String, Document> parts;

    public MessageVariable() {
        this.parts = new HashMap<String, Document>();
    }

    public MessageVariable(Map<String, Document> parts) {
        this.parts = parts;
    }

    public MessageVariable(javax.wsdl.Message wsdlMessage) {
        this();
        Map wsdlMessageParts = wsdlMessage.getParts();
        for (Map.Entry entry : wsdlMessageParts.entrySet()) {
            Part part = (Part)entry.getValue();
            String partName = part.getName();
            QName elementQName = part.getElementName();
            QName typeQName = part.getTypeName();
            if (typeQName != null) {
                this.parts.put(partName, BpelXmlUtil.createDefaultElement().getOwnerDocument());
                continue;
            }
            this.parts.put(partName, BpelXmlUtil.createElement(elementQName).getOwnerDocument());
        }
    }

    @Override
    public Element getPartValue(String partName) {
        if (partName != null) {
            if (this.parts.get(partName) != null) {
                return this.parts.get(partName).getDocumentElement();
            }
            return null;
        }
        return this.parts.values().iterator().next().getDocumentElement();
    }

    public boolean isPartInitialized(String partName) {
        return this.parts.get(partName) != null;
    }

    @Override
    public boolean hasPart(String partName) {
        if (partName != null) {
            return this.parts.containsKey(partName);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<message>");
        for (String part : this.parts.keySet()) {
            if (this.parts.get(part) == null) continue;
            buf.append("<" + part + ">");
            if (this.parts.get(part) == null) {
                buf.append("no_value_for_this_part");
            } else {
                buf.append(XmlUtil.toString(this.getPartValue(part)));
            }
            buf.append("</" + part + ">");
        }
        buf.append("</message>");
        return buf.toString();
    }

    @Override
    public MessageImpl copy() {
        if (this.parts == null) {
            return null;
        }
        HashMap<String, Document> duplicateMessageParts = new HashMap<String, Document>();
        Set<String> partNameSet = this.parts.keySet();
        for (String partName : partNameSet) {
            Document duplicatePart = null;
            Element oldElement = this.getPartValue(partName);
            if (oldElement != null) {
                duplicatePart = XmlUtil.getNewDocument();
                Node n = duplicatePart.importNode(oldElement, true);
                duplicatePart.appendChild(n);
            }
            duplicateMessageParts.put(partName, duplicatePart);
        }
        return new MessageImpl(duplicateMessageParts);
    }

    public MessageVariable duplicate() {
        if (this.parts == null) {
            return null;
        }
        MessageVariable duplicateMessage = new MessageVariable();
        Set<String> partNameSet = this.parts.keySet();
        for (String partName : partNameSet) {
            Document duplicatePart = null;
            Element oldElement = this.getPartValue(partName);
            if (oldElement != null) {
                duplicatePart = XmlUtil.getNewDocument();
                Node n = duplicatePart.importNode(oldElement, true);
                duplicatePart.appendChild(n);
            }
            duplicateMessage.parts.put(partName, duplicatePart);
        }
        return duplicateMessage;
    }

    public boolean equals(Object anotherMessage) {
        if (anotherMessage == null) {
            return false;
        }
        if (!(anotherMessage instanceof MessageVariable)) {
            return false;
        }
        MessageVariable message = (MessageVariable)anotherMessage;
        Map<String, Element> otherParts = message.getParts();
        return ((Object)otherParts).equals(this.getParts());
    }

    public int hashCode() {
        int hashCode = 0;
        for (Document messagePart : this.parts.values()) {
            hashCode += messagePart.hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, Element> getParts() {
        HashMap<String, Element> res = new HashMap<String, Element>();
        if (this.parts != null) {
            for (Map.Entry<String, Document> entry : this.parts.entrySet()) {
                if (entry.getValue() != null) {
                    res.put(entry.getKey(), entry.getValue().getDocumentElement());
                    continue;
                }
                res.put(entry.getKey(), null);
            }
        }
        return res;
    }

    public void setPart(String partName, Object value, boolean keepSrcElementName) {
        if (!this.hasPart(partName)) {
            throw new OrchestraRuntimeException("Invalid part name: " + partName);
        }
        Element currentValue = this.getPartValue(partName);
        BpelXmlUtil.setObjectValue(currentValue, value, keepSrcElementName);
    }
}

