/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.ArchiveUndeployedProcessHandler;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.test.services.runtime.AbstractQuerierTest;
import org.ow2.orchestra.util.EnvTool;

public class HistoryTest
extends AbstractQuerierTest {
    private int processFullInstanceSize;

    public static DefaultEnvXMLGenerator getHistoryEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        envGenerator.setFinishedInstanceHandlerType(new Class[]{ArchiveFinishedInstanceHandler.class});
        envGenerator.setUndeployedProcessHandlerType(new Class[]{ArchiveUndeployedProcessHandler.class});
        return envGenerator;
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        return HistoryTest.getHistoryEnvGenerator();
    }

    public void saveNewProcessInstance(final ProcessFullInstance processFullInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Archiver archiver = EnvTool.getArchiver();
                archiver.archive((Archivable)processFullInstance);
                return null;
            }
        });
    }

    public void saveNewActivityInstance(final ActivityFullInstance activityInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier archiver = EnvTool.getHistoryQueriers();
                archiver.getProcessInstance(activityInstance.getProcessInstanceUUID()).setEnclosedActivity(activityInstance);
                return null;
            }
        });
    }

    public void removeProcessInstance(final ProcessFullInstance processInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Archiver archiver = EnvTool.getArchiver();
                archiver.remove((Archivable)processInstance);
                return null;
            }
        });
    }

    public Querier getQuerier() {
        return EnvTool.getHistoryQueriers();
    }
}

