/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.TreeMap;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectMemory;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;

public class FileSystemMemory
extends FileSystem {
    public static final String PREFIX = "memFS:";
    public static final String PREFIX_LZF = "memLZF:";
    private static final FileSystemMemory INSTANCE = new FileSystemMemory();
    private static final TreeMap<String, FileObjectMemory> MEMORY_FILES = new TreeMap();

    private FileSystemMemory() {
    }

    public static FileSystemMemory getInstance() {
        return INSTANCE;
    }

    public long length(String string) {
        return this.getMemoryFile(string).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) {
        string = this.normalize(string);
        string2 = this.normalize(string2);
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileObjectMemory fileObjectMemory = this.getMemoryFile(string);
            fileObjectMemory.setName(string2);
            MEMORY_FILES.remove(string);
            MEMORY_FILES.put(string2, fileObjectMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile(String string) {
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            if (this.exists(string)) {
                return false;
            }
            this.getMemoryFile(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        string = this.normalize(string);
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string) {
        string = this.normalize(string);
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            MEMORY_FILES.remove(string);
        }
    }

    public boolean tryDelete(String string) {
        this.delete(string);
        return true;
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) {
        string = string + ".";
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            int n = 0;
            while (true) {
                String string3;
                if (!this.exists(string3 = string + (RandomUtils.getSecureLong() >>> 1) + string2)) {
                    this.getMemoryFile(string3);
                    return string3;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listFiles(String string) {
        ObjectArray<String> objectArray = ObjectArray.newInstance();
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            for (String string2 : MEMORY_FILES.tailMap(string).keySet()) {
                if (!string2.startsWith(string)) break;
                objectArray.add(string2);
            }
            String[] stringArray = new String[objectArray.size()];
            objectArray.toArray(stringArray);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecursive(String string, boolean bl) {
        string = this.normalize(string);
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            String string2;
            Iterator<String> iterator = MEMORY_FILES.tailMap(string).keySet().iterator();
            while (iterator.hasNext() && (string2 = iterator.next()).startsWith(string)) {
                iterator.remove();
            }
        }
    }

    public boolean isReadOnly(String string) {
        return false;
    }

    public String normalize(String string) {
        int n = (string = string.replace('\\', '/')).indexOf(":/");
        if (n > 0) {
            string = string.substring(0, n + 1) + string.substring(n + 2);
        }
        return string;
    }

    public String getParent(String string) {
        int n = (string = this.normalize(string)).lastIndexOf(47);
        if (n < 0) {
            n = string.indexOf(58) + 1;
        }
        return string.substring(0, n);
    }

    public boolean isDirectory(String string) {
        return false;
    }

    public boolean isAbsolute(String string) {
        return true;
    }

    public String getAbsolutePath(String string) {
        return this.normalize(string);
    }

    public long getLastModified(String string) {
        return this.getMemoryFile(string).getLastModified();
    }

    public boolean canWrite(String string) {
        return true;
    }

    public void copy(String string, String string2) throws SQLException {
        try {
            OutputStream outputStream = this.openFileOutputStream(string2, false);
            InputStream inputStream = this.openFileInputStream(string);
            IOUtils.copyAndClose(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "Can not copy " + string + " to " + string2);
        }
    }

    public void createDirs(String string) {
    }

    public String getFileName(String string) {
        int n = Math.max(string.indexOf(58), string.lastIndexOf(47));
        return n < 0 ? string : string.substring(n + 1);
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.normalize(string);
        string2 = this.normalize(string2);
        return string.startsWith(string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) throws SQLException {
        try {
            FileObjectMemory fileObjectMemory = this.getMemoryFile(string);
            fileObjectMemory.seek(0L);
            return new FileObjectOutputStream(fileObjectMemory, bl);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    public InputStream openFileInputStream(String string) {
        FileObjectMemory fileObjectMemory = this.getMemoryFile(string);
        fileObjectMemory.seek(0L);
        return new FileObjectInputStream(fileObjectMemory);
    }

    public FileObject openFileObject(String string, String string2) {
        FileObjectMemory fileObjectMemory = this.getMemoryFile(string);
        fileObjectMemory.seek(0L);
        return fileObjectMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObjectMemory getMemoryFile(String string) {
        string = this.normalize(string);
        TreeMap<String, FileObjectMemory> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileObjectMemory fileObjectMemory = MEMORY_FILES.get(string);
            if (fileObjectMemory == null) {
                boolean bl = string.startsWith(PREFIX_LZF);
                fileObjectMemory = new FileObjectMemory(string, bl);
                MEMORY_FILES.put(string, fileObjectMemory);
            }
            return fileObjectMemory;
        }
    }

    protected boolean accepts(String string) {
        return string.startsWith(PREFIX) || string.startsWith(PREFIX_LZF);
    }
}

