/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;
import org.ow2.orchestra.util.Misc;

public class GetProcessAction
implements ClientAction {
    private final Options options = ClientOptions.createGetProcessOptions();

    public static ProcessDefinition get(String jmxServiceUrl, String jmxObjectName, QName processQName) {
        try {
            RemoteDeployerMBean mbean = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
            List<ProcessDefinition> res = mbean.findProcessDefinitions(processQName, ProcessState.DEPLOYED);
            if (res != null && !res.isEmpty()) {
                return res.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error while getting process info " + processQName.toString(), e);
        }
    }

    protected static void get(CommandLine line) {
        QName processQName = null;
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        if (line.hasOption("process")) {
            processQName = QName.valueOf(line.getOptionValue("process"));
        }
        ProcessDefinition recProc = GetProcessAction.get(jmxServiceUrl, jmxObjectName, processQName);
        System.out.println("Informations of the deployed processes :");
        if (recProc != null) {
            System.out.println(recProc.getQName());
        }
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        GetProcessAction.get(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To get the informations of the deployed BPEL process";
    }
}

