/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.xml.WSDLLocator;
import org.ow2.orchestra.util.wsdl.WsdlException;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private static Logger log = Logger.getLogger(WSDLLocatorImpl.class.getName());
    private final URL wsdlURL;
    private String latestImportURI;

    public WSDLLocatorImpl(URL wsdlFile) {
        if (wsdlFile == null) {
            throw new IllegalArgumentException("WSDL file argument cannot be null");
        }
        this.wsdlURL = wsdlFile;
    }

    public InputSource getBaseInputSource() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getBaseInputSource [wsdlUrl=" + this.wsdlURL + "]");
        }
        try {
            InputStream is = this.wsdlURL.openStream();
            return new InputSource(is);
        }
        catch (IOException e) {
            throw new WsdlException("Cannot access wsdl from [" + this.wsdlURL + "], ", e);
        }
    }

    public String getBaseURI() {
        return this.wsdlURL.toExternalForm();
    }

    public InputSource getImportInputSource(String parent, String resource) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getImportInputSource [parent=" + parent + ",resource=" + resource + "]");
        }
        URL parentURL = null;
        try {
            parentURL = new URL(parent);
        }
        catch (MalformedURLException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Not a valid URL: " + parent);
            }
            return null;
        }
        String wsdlImport = null;
        String external = parentURL.toExternalForm();
        if (resource.startsWith("http://") || resource.startsWith("https://")) {
            wsdlImport = resource;
        } else if (resource.startsWith("/")) {
            String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
            wsdlImport = beforePath + resource;
        } else {
            String parentDir = external.substring(0, external.lastIndexOf("/"));
            while (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            while (resource.startsWith("../")) {
                parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                resource = resource.substring(3);
            }
            wsdlImport = parentDir + "/" + resource;
        }
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Trying to resolve: " + wsdlImport);
            }
            InputSource inputSource = new InputSource(wsdlImport);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Trying to resolve: inputSource = " + inputSource);
            }
            if (inputSource != null) {
                this.latestImportURI = wsdlImport;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Trying to resolve: latestImportURI = " + this.latestImportURI);
                }
            } else {
                throw new IllegalArgumentException("Cannot resolve imported resource: " + wsdlImport);
            }
            return inputSource;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WsdlException("Cannot access imported wsdl [" + wsdlImport + "], ", e);
        }
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
    }
}

