/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.catchAll;

import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InvokerCatchAllTest
extends RemoteTestCase {
    private static final String PROCESS_NAME = "failBpel";
    private static final String PROCESS_NAMESPACE = "http://orchestra.ow2.org/failBpel";
    private static final QName PROCESS_QNAME = new QName("http://orchestra.ow2.org/failBpel", "failBpel");
    private static final QName FAIL_SERVICE_QNAME = new QName("tns:http://orchestra.ow2.org/failService/failService", "failService");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokerFaultTransformation() throws Exception {
        Thread t = null;
        this.deploy(FAIL_SERVICE_QNAME.getLocalPart());
        this.deploy(PROCESS_NAME);
        try {
            String random = UUID.randomUUID().toString();
            String part = "<failBpelRequest xmlns='http://orchestra.ow2.org/failBpel'>" + random + "</failBpelRequest>";
            String processEndpoint = this.getDefaultEndpoint("failBpelPort");
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)PROCESS_NAMESPACE, (String)part);
            SOAPMessage responded = SOAPUtil.call((SOAPMessage)request, (String)processEndpoint);
            Assert.assertNotNull((Object)responded);
            Assert.assertFalse((boolean)responded.getSOAPBody().hasFault());
            SOAPBodyElement result = (SOAPBodyElement)responded.getSOAPBody().getChildElements().next();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"failBpelMessage", (String)result.getLocalName());
            Assert.assertEquals((String)PROCESS_NAMESPACE, (String)result.getNamespaceURI());
            NodeList texts = result.getChildNodes();
            Assert.assertEquals((int)1, (int)texts.getLength());
            Assert.assertTrue((boolean)(texts.item(0) instanceof Text));
            Assert.assertEquals((String)random, (String)texts.item(0).getTextContent());
        }
        finally {
            if (t != null) {
                t.interrupt();
            }
        }
        this.undeploy(PROCESS_QNAME);
        this.undeploy(FAIL_SERVICE_QNAME);
    }
}

