/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.definition.element.Source;
import org.ow2.orchestra.definition.element.Target;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.JoinCondition;
import org.ow2.orchestra.pvm.activity.ActivityExecution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.FlowRuntime;
import org.ow2.orchestra.runtime.LinkRuntime;
import org.ow2.orchestra.services.job.ExecuteSourcesMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBpelActivity
extends AbstractActivity {
    private static final long serialVersionUID = 8757394004727477526L;
    private static Logger log = Logger.getLogger(AbstractBpelActivity.class.getName());
    protected Scope enclosingScope;
    protected boolean suppressJoinFailure;
    protected boolean executeSourcesAsync = false;
    protected JoinCondition targetsJoinCondition = null;
    protected List<Source> sources = null;
    protected List<Target> targets = null;

    @Override
    public void execute(ActivityExecution execution) {
        BpelExecution bpelExecution = (BpelExecution)execution;
        this.beforeRunning(bpelExecution);
        TargetBehaviour targetBehaviour = this.targetsOK(bpelExecution);
        if (targetBehaviour == TargetBehaviour.execute) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("### Executing " + execution.getNode().getName() + " in execution " + execution);
            }
            this.executeActivity(bpelExecution);
        } else if (targetBehaviour != TargetBehaviour.notexecute) {
            bpelExecution.waitForSignal();
        }
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        throw new OrchestraRuntimeException("Signal not supported.");
    }

    private TargetBehaviour targetsOK(BpelExecution execution) {
        if (this.targets == null || this.targets.isEmpty()) {
            return TargetBehaviour.execute;
        }
        boolean tjcLogicalOR = false;
        for (Target target : this.targets) {
            String linkName = target.getLinkName();
            FlowRuntime fr = execution.getFlowRuntimeWithLink(linkName);
            Boolean linkStatus = fr.getLinkStatus(linkName);
            if (linkStatus == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getClass() + "." + this.getName() + " targetsOK, waiting for link : " + linkName);
                }
                fr.addWaitingExecution(linkName, execution);
                return TargetBehaviour.unresolved;
            }
            tjcLogicalOR = tjcLogicalOR || linkStatus != false;
        }
        boolean tjc = tjcLogicalOR;
        if (this.targetsJoinCondition != null) {
            try {
                tjc = this.targetsJoinCondition.getEvaluator().evaluateBoolean(execution);
            }
            catch (BpelFaultException e) {
                throw e;
            }
            catch (Exception e) {
                this.setAllUnsetLinks(execution);
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.joinFailure, "bpel:joinFailure : " + this.targetsJoinCondition.getText() + ", exception while evaluating the targetJoinCondition", e);
            }
        }
        if (!tjc) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getClass() + ".targetsOK : " + false);
            }
            if (!this.suppressJoinFailure) {
                if (this.targetsJoinCondition != null) {
                    throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.joinFailure, "bpel:joinFailure : " + this.targetsJoinCondition.getText() + ", targetJoinCondition is false and suppressJoinFailure is no", null);
                }
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.joinFailure, "bpel:joinFailure : targetJoinCondition is false and suppressJoinFailure is no", null);
            }
            if (this.sources != null) {
                for (Source source : this.sources) {
                    BpelExecution execToWakeUp;
                    String linkName = source.getLinkName();
                    FlowRuntime fr = execution.getFlowRuntimeWithLink(linkName);
                    LinkRuntime lr = fr.getLink(linkName);
                    if (lr.getStatus() == null) {
                        lr.setStatus(false);
                    }
                    if ((execToWakeUp = fr.getWaitingExecution(linkName)) == null) continue;
                    execToWakeUp.execute(execToWakeUp.getNode());
                }
            }
            return TargetBehaviour.notexecute;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getClass() + "." + this.getName() + " targetsOK : " + true);
        }
        return TargetBehaviour.execute;
    }

    @Override
    public void afterRunned(BpelExecution execution) {
        execution.setState("async");
        super.afterRunned(execution);
        if (this.executeSourcesAsync) {
            Environment.getFromCurrent(MessageSession.class).send(new ExecuteSourcesMessage(execution));
            execution.waitForSignal();
        } else {
            this.executeSources(execution);
        }
    }

    public void executeSources(BpelExecution execution) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing sources of activity : " + this.getClass().getName() + "." + this.name);
        }
        if (this.sources == null) {
            return;
        }
        for (Source source : this.sources) {
            FlowRuntime fr;
            BpelExecution execToWakeUp;
            String linkName = source.getLinkName();
            boolean tc = true;
            if (source.getTransitionCondition() != null) {
                try {
                    tc = source.getTransitionCondition().getEvaluator().evaluateBoolean(execution);
                }
                catch (Exception e) {
                    this.setAllUnsetLinks(execution);
                    e.printStackTrace();
                }
            }
            execution.setLinkStatus(linkName, tc);
            if (log.isLoggable(Level.FINE)) {
                log.fine("executeSources, notifying executions of the link : " + linkName + "(" + tc + ")");
            }
            if ((execToWakeUp = (fr = execution.getFlowRuntimeWithLink(linkName)).getWaitingExecution(linkName)) == null) continue;
            execToWakeUp.execute(execToWakeUp.getNode());
        }
        execution.unlock();
    }

    private void setAllUnsetLinks(BpelExecution execution) {
        if (this.sources != null) {
            for (Source source : this.sources) {
                Scope sourceActivityEnclosingScope;
                Link link;
                Scope targetActivityEnclosingScope;
                String linkName = source.getLinkName();
                FlowRuntime fr = execution.getFlowRuntimeWithLink(linkName);
                LinkRuntime lr = fr.getLink(linkName);
                if (lr.getStatus() != null || (targetActivityEnclosingScope = (link = source.getLink()).getTargetActivity().getEnclosingScope()) == (sourceActivityEnclosingScope = link.getSourceActivity().getEnclosingScope())) continue;
                lr.setStatus(false);
            }
        }
    }

    protected abstract void executeActivity(BpelExecution var1);

    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    public void setEnclosingScope(Scope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public boolean isSuppressJoinFailure() {
        return this.suppressJoinFailure;
    }

    public void setSuppressJoinFailure(boolean suppressJoinFailure) {
        this.suppressJoinFailure = suppressJoinFailure;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public JoinCondition getTargetsJoinCondition() {
        return this.targetsJoinCondition;
    }

    public void setTargetsJoinCondition(JoinCondition targetsJoinCondition) {
        this.targetsJoinCondition = targetsJoinCondition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetBehaviour {
        execute,
        unresolved,
        notexecute;

    }
}

