/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.OnAlarm;
import org.ow2.orchestra.definition.element.OnMessage;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.CheckHasMessageJob;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pick
extends AbstractBpelActivity
implements InboundMessageElement {
    private static final long serialVersionUID = 1L;
    public static final String ON_ALARM_PARAM = "onAlarm";
    protected List<OnMessage> onMessages;
    protected List<OnAlarm> onAlarms;
    protected boolean createInstance = false;

    public Pick() {
        this.executeSourcesAsync = true;
    }

    @Override
    public void executeActivity(BpelExecution execution) {
        BpelProcess process = execution.getProcessDefinition();
        if (!this.onMessages.isEmpty()) {
            for (OnMessage onMsg : this.onMessages) {
                OperationKey opKey = onMsg.getOperationKey();
                execution.getWaitingOperationKeys().add(opKey);
            }
            Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(execution));
        }
        if (this.onAlarms != null) {
            for (OnAlarm onAlarm : this.onAlarms) {
                Date date = OnAlarm.computeTimer(execution, onAlarm.getDeadlineExpression(), onAlarm.getDurationExpression(), onAlarm.getRepeatEveryExpression());
                execution.createTimer(null, onAlarm.getUuid(), null, date, null, null, null);
                EnvTool.getRecorder().recordTimerStarted(new TimerData(execution.getActivityInstanceUUID(), null, date));
            }
        }
        execution.waitForSignal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (parameters != null) {
            OnMessage onMessage = (OnMessage)parameters.get("receivingElement");
            NodeImpl onAlarmActivity = (NodeImpl)parameters.get(ON_ALARM_PARAM);
            if (onMessage != null || onAlarmActivity != null) {
                execution.getWaitingOperationKeys().clear();
                execution.removeJobs();
            }
            if (onMessage != null) {
                MessageVariable message = (MessageVariable)parameters.get("message");
                MessageCarrier messageCarrier = (MessageCarrier)parameters.get("messageCarrier");
                ReceivingElementUtil.receive(onMessage, message, messageCarrier, execution);
                NodeImpl node = onMessage.getActivity();
                execution.createExecution().execute(node);
                return;
            } else {
                if (onAlarmActivity == null) throw new OrchestraRuntimeException("Unsupported signal parameters");
                execution.createExecution().execute(onAlarmActivity);
            }
            return;
        } else {
            if (signal != null) {
                if (signal.equals("finished")) {
                    this.afterRunned(execution);
                    return;
                }
                boolean found = false;
                for (OnAlarm onAlarm : this.onAlarms) {
                    if (!signal.equals(onAlarm.getUuid())) continue;
                    found = true;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(ON_ALARM_PARAM, onAlarm.getActivity());
                    this.signal(execution, null, params);
                }
                if (found) return;
                throw new OrchestraRuntimeException("Unsupported signal " + signal);
            }
            execution.end("ended");
            BpelExecution pickExecution = execution.getParent();
            pickExecution.removeExecution(execution);
            pickExecution.signal("finished");
        }
    }

    public boolean isCreateInstance() {
        return this.createInstance;
    }

    public void setCreateInstance(boolean createInstance) {
        this.createInstance = createInstance;
    }

    public List<OnMessage> getOnMessages() {
        return this.onMessages;
    }

    public void setOnMessages(List<OnMessage> onMessages) {
        this.onMessages = onMessages;
    }

    public List<OnAlarm> getOnAlarms() {
        return this.onAlarms;
    }

    public void setOnAlarms(List<OnAlarm> onAlarms) {
        this.onAlarms = onAlarms;
    }

    @Override
    public List<ReceivingElement> getReceivingElements() {
        return new ArrayList<ReceivingElement>(this.onMessages);
    }

    @Override
    public ActivityType getType() {
        return ActivityType.PICK;
    }
}

