/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.runtime.BpelExecution;

public class Copy {
    private static Logger log = Logger.getLogger(Copy.class.getName());
    protected long dbid;
    protected boolean keepSrcElementName;
    protected boolean ignoreMissingFromData;
    protected From from;
    protected To to;

    public void execute(BpelExecution execution) {
        Object fromValue = this.from.getValue(execution);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Copy from value = " + fromValue);
        }
        if (fromValue == null) {
            if (this.ignoreMissingFromData) {
                return;
            }
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure, "fromValue is null, copy = " + this.toString(), null);
        }
        this.to.setValue(execution, fromValue, this.keepSrcElementName);
    }

    public String toString() {
        String result = "<copy  keepSrcElementName=\"" + this.keepSrcElementName + "\">\n";
        result = result + this.from.toString();
        result = result + this.to.toString();
        result = result + "</copy>\n";
        return result;
    }

    public boolean isKeepSrcElementName() {
        return this.keepSrcElementName;
    }

    public From getFrom() {
        return this.from;
    }

    public To getTo() {
        return this.to;
    }

    public boolean isIgnoreMissingFromData() {
        return this.ignoreMissingFromData;
    }

    public void setIgnoreMissingFromData(boolean ignoreMissingFromData) {
        this.ignoreMissingFromData = ignoreMissingFromData;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public void setKeepSrcElementName(boolean keepSrcElementName) {
        this.keepSrcElementName = keepSrcElementName;
    }

    public void setTo(To to) {
        this.to = to;
    }
}

