/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PartnerLink
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected String name;
    protected QName myRolePortTypeQName;
    protected QName partnerRolePortTypeQName;
    protected boolean initializePartnerRole = false;
    protected Element defaultPartnerRoleEndPointReference;
    protected Element defaultMyRoleEndPointReference;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInitializePartnerRole(boolean initializePartnerRole) {
        this.initializePartnerRole = initializePartnerRole;
    }

    public QName getMyRolePortTypeQName() {
        return this.myRolePortTypeQName;
    }

    public void setMyRolePortTypeQName(QName myRolePortTypeQName) {
        this.myRolePortTypeQName = myRolePortTypeQName;
    }

    public QName getPartnerRolePortTypeQName() {
        return this.partnerRolePortTypeQName;
    }

    public void setPartnerRolePortTypeQName(QName partnerRolePortTypeQName) {
        this.partnerRolePortTypeQName = partnerRolePortTypeQName;
    }

    public boolean getInitializePartnerRole() {
        return this.initializePartnerRole;
    }

    public Element getDefaultMyRoleEndPointReference() {
        return this.defaultMyRoleEndPointReference;
    }

    public Element getDefaultPartnerRoleEndPointReference() {
        return this.defaultPartnerRoleEndPointReference;
    }

    public void getDefaultEndpoints(WsdlsInfos wsdlInfos) {
        this.initializePartnerRole(wsdlInfos);
        this.initializeMyRole(wsdlInfos);
    }

    private void initializePartnerRole(WsdlsInfos wsdlsInfos) {
        Port defaultPort = null;
        if (this.partnerRolePortTypeQName == null) {
            return;
        }
        List<Port> ports = wsdlsInfos.getPorts(this.partnerRolePortTypeQName);
        HashMap<Port, SOAPAddress> supported = new HashMap<Port, SOAPAddress>();
        for (Port port : ports) {
            List elements = port.getExtensibilityElements();
            if (elements.size() > 0) {
                for (ExtensibilityElement element : elements) {
                    if (!(element instanceof SOAPAddress) || !port.getBinding().getPortType().getQName().equals(this.partnerRolePortTypeQName)) continue;
                    supported.put(port, (SOAPAddress)element);
                }
                continue;
            }
            supported.put(port, null);
        }
        SOAPAddress soapAddress = null;
        Service service = null;
        if (supported.entrySet() != null && supported.entrySet().size() > 0) {
            Map.Entry entry = supported.entrySet().iterator().next();
            defaultPort = (Port)entry.getKey();
            soapAddress = (SOAPAddress)entry.getValue();
            Misc.log(Level.FINEST, "Using the supported port: " + defaultPort, new Object[0]);
            service = wsdlsInfos.getServiceOfPort(defaultPort);
        }
        if (service != null) {
            Document document = BpelUtil.getServiceRefDocument(soapAddress, service.getQName());
            this.defaultPartnerRoleEndPointReference = document.getDocumentElement();
        }
    }

    private void initializeMyRole(WsdlsInfos wsdlsInfos) {
        if (this.myRolePortTypeQName == null) {
            return;
        }
        List<Port> ports = wsdlsInfos.getPorts(this.myRolePortTypeQName);
        if (ports.isEmpty()) {
            return;
        }
        Port defaultPort = ports.get(0);
        Service service = wsdlsInfos.getServiceOfPort(defaultPort);
        List elements = defaultPort.getExtensibilityElements();
        SOAPAddress soapAddress = (SOAPAddress)BpelUtil.findExtensibilityElement(elements, SOAPAddress.class);
        this.defaultMyRoleEndPointReference = BpelUtil.getServiceRefDocument(soapAddress, service.getQName()).getDocumentElement();
    }
}

