/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.lang.management.ManagementFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.orchestra.cluster.JmxServer;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployer;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;

public class JMXAgent {
    private MBeanServer mbs;
    private ObjectName objectName;
    private JMXConnectorServer cs;
    private Registry registry;

    public void startOrchestra(EnvironmentFactory envFactory) {
        EnvFactoryRepository.set(envFactory);
        Properties orchestraProperties = (Properties)envFactory.get("orchestra-properties");
        String jmxServiceUrl = orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
        String jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
        JmxServer orchestraServer = new JmxServer(jmxServiceUrl, jmxObjectName);
        RemoteDeployer remoteDeployer = new RemoteDeployer(orchestraServer);
        remoteDeployer.initialize();
        JobExecutor jobExecutor = envFactory.get(JobExecutor.class);
        if (jobExecutor != null) {
            if (jobExecutor instanceof AbstractJobExecutor) {
                ((AbstractJobExecutor)jobExecutor).setName(((Object)orchestraServer).toString());
            }
            jobExecutor.start();
        }
        try {
            int jmxPort = Integer.parseInt(orchestraProperties.getProperty("orchestra.jmx.port"));
            this.registry = LocateRegistry.createRegistry(jmxPort);
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            this.objectName = ObjectName.getInstance(jmxObjectName);
            this.mbs.registerMBean(remoteDeployer, this.objectName);
            JMXServiceURL url = new JMXServiceURL(jmxServiceUrl);
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
            this.cs.start();
            Misc.log(Level.INFO, "Orchestra is started using JMX connector [" + url.toString() + "]", new Object[0]);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Problem registering mbean in mbean server", e);
        }
    }

    public void stopOrchestra() {
        if (this.mbs != null) {
            try {
                this.cs.stop();
                this.mbs.unregisterMBean(this.objectName);
                this.mbs = null;
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Problem unregistering mbean", e);
            }
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                throw new OrchestraRuntimeException("Problem unregistering rmi registry", e);
            }
            this.registry = null;
        }
        if (EnvFactoryRepository.get() != null) {
            JobExecutor jobExecutor = EnvFactoryRepository.get().get(JobExecutor.class);
            if (jobExecutor != null) {
                jobExecutor.stop(true);
            }
            EnvFactoryRepository.get().close();
            EnvFactoryRepository.set(null);
        }
    }
}

