/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jaxen.FunctionCallException;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.ow2.orchestra.definition.element.PartDefinition;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.lang.PropertyQuery;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelVariableContext
implements VariableContext,
Serializable {
    private final BpelExecution bpelExecution;
    private static final long serialVersionUID = 1L;

    public BpelVariableContext(BpelExecution bpelExecution) {
        if (bpelExecution == null) {
            throw new NullPointerException("bpelExecution must not be null");
        }
        this.bpelExecution = bpelExecution;
    }

    public BpelExecution getBpelExecution() {
        return this.bpelExecution;
    }

    public Object getValueForAssign(String variableName) {
        return this.bpelExecution.getVariableValue(variableName);
    }

    public void setValue(String variableName, Object value) {
        this.bpelExecution.getVariableByName(variableName).setValue(value, false);
    }

    public Object getPropertyValue(String variableName, QName propertyQName) throws FunctionCallException {
        VariableRuntime variable = null;
        variable = this.bpelExecution.getVariableByName(variableName);
        if (variable == null) {
            throw new FunctionCallException("Unable to locate a bound variable for variableName : " + variableName);
        }
        PropertyAlias propertyAlias = null;
        Element value = null;
        Variable variableDefinition = variable.getVariableDefinition();
        if (variable.getVariableDefinition().getMessageType() != null) {
            propertyAlias = this.bpelExecution.getPropertyAliasWithMessageType(propertyQName, variableDefinition.getMessageType());
        } else if (variable.getVariableDefinition().getElement() != null) {
            propertyAlias = this.bpelExecution.getPropertyAliasWithElement(propertyQName, variableDefinition.getElement());
        } else if (variable.getVariableDefinition().getXmlType() != null) {
            propertyAlias = this.bpelExecution.getPropertyAliasWithType(propertyQName, variableDefinition.getXmlType());
        } else {
            throw new IllegalStateException("Invalid variable type");
        }
        if (variable.getVariableDefinition().getMessageType() != null) {
            MessageVariable varValue = (MessageVariable)variable.getValue();
            value = varValue.getPartValue(propertyAlias.getPart());
        } else {
            value = (Element)variable.getValue();
        }
        PropertyQuery query = propertyAlias.getQuery();
        if (query != null) {
            return query.getEvaluator().evaluate(value, this.bpelExecution);
        }
        return value;
    }

    public Variable findVariableDefinition(String variableName) {
        VariableRuntime variableRuntime = this.bpelExecution.getVariableByName(variableName);
        if (variableRuntime == null) {
            return null;
        }
        return variableRuntime.getVariableDefinition();
    }

    @Override
    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (namespaceURI != null) {
            throw new UnresolvableException("variable not found: " + prefix + ':' + localName);
        }
        Object value = null;
        int dotIndex = localName.indexOf(46);
        if (dotIndex == -1) {
            Variable definition = this.findVariableDefinition(localName);
            if (definition == null) {
                throw new UnresolvableException("variable not found: " + localName);
            }
            value = this.bpelExecution.getVariableValue(localName);
            if (definition.getMessageType() != null) {
                throw new UnresolvableException("illegal access to message variable: " + localName);
            }
            if (definition.getXmlType() != null && BpelXmlUtil.isDefaultElement((Element)value)) {
                Element valueElement = (Element)value;
                if ("http://www.w3.org/2001/XMLSchema".equals(definition.getXmlType().getNamespaceURI())) {
                    value = definition.getXmlType().getLocalPart().equals("boolean") ? Boolean.valueOf(valueElement.getTextContent()) : (definition.getXmlType().getLocalPart().equals("float") || definition.getXmlType().getLocalPart().equals("int") || definition.getXmlType().getLocalPart().equals("unsignedInt") ? Double.valueOf(valueElement.getTextContent()) : valueElement.getTextContent());
                }
            }
        } else {
            String messageName = localName.substring(0, dotIndex);
            Variable definition = this.findVariableDefinition(messageName);
            if (definition == null) {
                throw new UnresolvableException("variable not found: " + messageName);
            }
            value = this.bpelExecution.getVariableValue(messageName);
            if (definition.getMessageType() == null) {
                throw new UnresolvableException("illegal access to part of non-message variable: " + localName);
            }
            MessageVariable messageValue = (MessageVariable)value;
            String partName = localName.substring(dotIndex + 1);
            value = messageValue.getPartValue(partName);
            PartDefinition partDefinition = definition.getMessageParts().get(partName);
            if (partDefinition.getXmlType() != null && BpelXmlUtil.isDefaultElement((Element)value)) {
                Element valueElement = (Element)value;
                QName typeName = partDefinition.getXmlType();
                if ("http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI())) {
                    value = typeName.getLocalPart().equals("boolean") ? Boolean.valueOf(valueElement.getTextContent()) : (typeName.getLocalPart().equals("float") || typeName.getLocalPart().equals("int") || typeName.getLocalPart().equals("unsignedInt") ? Double.valueOf(valueElement.getTextContent()) : valueElement.getTextContent());
                }
            }
        }
        return value;
    }

    public Map<String, byte[]> getStyleSheets() {
        return this.bpelExecution.getProcessDefinition().getResourcesRepository().getResources();
    }
}

