/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.lang.function.BooleanFromStringFunction;
import org.ow2.orchestra.lang.function.DoXslTransformationFunction;
import org.ow2.orchestra.lang.function.GetVariablePropertyFunction;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class XPathEvaluator
extends BaseXPath {
    private static final FunctionContext EMPTY_FUNCTION_CONTEXT = new SimpleFunctionContext();
    private static final Logger LOG = Logger.getLogger(XPathEvaluator.class.getName());
    private static final long serialVersionUID = 1L;

    XPathEvaluator(String text) throws JaxenException {
        super(text, DocumentNavigator.getInstance());
    }

    protected List selectOrCreateNodes(LocationPath location, Context context) throws JaxenException {
        List<Node> contextNodes = context.getNodeSet();
        if (contextNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ContextSupport support = context.getContextSupport();
        if (location.isAbsolute()) {
            Object rootNode = support.getNavigator().getDocumentNode(contextNodes.get(0));
            contextNodes = Collections.singletonList(rootNode);
        }
        Iterator stepIter = location.getSteps().iterator();
        while (stepIter.hasNext()) {
            Context stepContext = new Context(support);
            stepContext.setNodeSet(contextNodes);
            Step step = (Step)stepIter.next();
            contextNodes = step.evaluate(stepContext);
            if (!contextNodes.isEmpty()) continue;
            Node newNode = this.createNode(step, stepContext);
            contextNodes = Collections.singletonList(newNode);
        }
        return contextNodes;
    }

    private Node createNode(Step step, Context context) {
        Node newNode;
        List nodeset = context.getNodeSet();
        if (nodeset.size() != 1) {
            LOG.severe("cannot create node for context node set of size other than one: " + nodeset);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        Object contextNode = nodeset.get(0);
        if (!(contextNode instanceof Element)) {
            LOG.severe("cannot create node for non-element context node: " + contextNode);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        Element contextElem = (Element)contextNode;
        switch (step.getAxis()) {
            case 9: {
                newNode = this.createAttribute(step, context, contextElem);
                break;
            }
            case 1: {
                newNode = step instanceof NameStep ? this.createElement((NameStep)step, context, contextElem) : this.createNonElementChild(step, contextElem);
                contextElem.appendChild(newNode);
                break;
            }
            default: {
                LOG.severe("cannot create node on the specified axis: " + step);
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
            }
        }
        return newNode;
    }

    private Attr createAttribute(Step step, Context context, Element contextElem) {
        if (!step.getPredicates().isEmpty()) {
            LOG.severe("cannot create attribute for step with predicates: " + step);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        if (!(step instanceof NameStep)) {
            LOG.severe("cannot create attribute for non-name node test: " + step);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        NameStep nameStep = (NameStep)step;
        String localName = nameStep.getLocalName();
        if ("*".equals(localName)) {
            LOG.severe("cannot create attribute for any-name node test: " + nameStep);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        String prefix = nameStep.getPrefix();
        String namespaceURI = context.translateNamespacePrefixToUri(prefix);
        Attr attribute = contextElem.getOwnerDocument().createAttributeNS(namespaceURI, namespaceURI != null ? prefix + ':' + localName : localName);
        contextElem.setAttributeNodeNS(attribute);
        return attribute;
    }

    private Element createElement(NameStep step, Context context, Element contextElem) {
        String localName = step.getLocalName();
        if ("*".equals(localName)) {
            LOG.severe("cannot create node for any-name node tests: " + step);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
        }
        String prefix = step.getPrefix();
        String namespaceURI = context.translateNamespacePrefixToUri(prefix);
        List predicates = step.getPredicates();
        switch (predicates.size()) {
            case 0: {
                break;
            }
            case 1: {
                List contextNodes = this.getElements(contextElem, namespaceURI, localName);
                Context predicateContext = new Context(context.getContextSupport());
                predicateContext.setNodeSet(contextNodes);
                try {
                    Predicate predicate = (Predicate)predicates.get(0);
                    Object result = predicate.evaluate(predicateContext);
                    if (!(result instanceof Number)) {
                        LOG.severe("cannot create element for step with non-numeric predicate: " + step);
                        throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
                    }
                    if (((Number)result).intValue() != contextNodes.size() + 1) {
                        LOG.severe("cannot create element for step with numeric predicate beyond the next position: " + step);
                        throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
                    }
                    break;
                }
                catch (JaxenException e) {
                    LOG.log(Level.SEVERE, "predicate evaluation failed", e);
                    throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, null, e);
                }
            }
            default: {
                LOG.severe("cannot create element for step with multiple predicates: " + step);
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure);
            }
        }
        String qualifiedName = namespaceURI != null ? prefix + ':' + localName : localName;
        Element newElt = contextElem.getOwnerDocument().createElementNS(namespaceURI, qualifiedName);
        contextElem.appendChild(newElt);
        BpelXmlUtil.ensureOwnNamespaceDeclared(newElt);
        return newElt;
    }

    private Node createNonElementChild(Step step, Element contextElem) {
        if (!step.getPredicates().isEmpty()) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure, "cannot create node for step with predicates: " + step, null);
        }
        Document contextDoc = contextElem.getOwnerDocument();
        if (step instanceof TextNodeStep) {
            return contextDoc.createTextNode("");
        }
        if (step instanceof ProcessingInstructionNodeStep) {
            ProcessingInstructionNodeStep processingStep = (ProcessingInstructionNodeStep)step;
            return contextDoc.createProcessingInstruction(processingStep.getName(), "");
        }
        if (step instanceof CommentNodeStep) {
            return contextDoc.createComment("");
        }
        throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure, "cannot create node for any-node tests on the child axis: " + step, null);
    }

    private List getElements(Element parent, String namespaceURI, String localName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!BpelXmlUtil.nodeNameEquals(child, namespaceURI, localName)) continue;
            elements.add(child);
        }
        return elements;
    }

    protected Node narrowToSingleNode(List nodeset) {
        LOG.finest("narrowing to single node: " + nodeset);
        if (nodeset == null || nodeset.size() != 1) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure, "selection of size other than one: " + nodeset, null);
        }
        Object singleResult = nodeset.get(0);
        if (!(singleResult instanceof Node)) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.selectionFailure, "selection is not a node: " + singleResult, null);
        }
        return (Node)singleResult;
    }

    protected static FunctionContext readFunctionLibrary() {
        XPathFunctionContext fc = new XPathFunctionContext();
        fc.registerFunction("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "getVariableProperty", new GetVariablePropertyFunction());
        fc.registerFunction("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "doXslTransform", new DoXslTransformationFunction());
        fc.registerFunction("http://orchestra.ow2.org", "boolean-from-string", new BooleanFromStringFunction());
        return fc;
    }
}

