/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.VariableReferenceExpr;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.evaluator.ExpressionEvaluator;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;
import org.ow2.orchestra.lang.jaxen.ExprVisitor;
import org.ow2.orchestra.lang.jaxen.XPathEvaluator;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Node;

class XPathExpressionEvaluator
extends XPathEvaluator
implements ExpressionEvaluator {
    private static DatatypeFactory datatypeFactory;
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static final FunctionContext FUNTION_LIBRARY;

    XPathExpressionEvaluator(String text) throws JaxenException {
        super(text);
    }

    public Object evaluate(BpelExecution bpelExecution) {
        try {
            List nodeSet = this.selectNodes(bpelExecution);
            if (nodeSet != null) {
                switch (nodeSet.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return nodeSet.get(0);
                    }
                    default: {
                        return nodeSet;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "expression evaluation failed", e);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, "expression evaluation failed", e);
        }
    }

    public String assign(BpelExecution bpelExecution, Object value, boolean keepSrcEltName) {
        Expr rootExpr = this.getRootExpr();
        Context context = this.getContext(bpelExecution);
        if (rootExpr instanceof VariableReferenceExpr) {
            return XPathExpressionEvaluator.assignVariable((VariableReferenceExpr)rootExpr, context, value, keepSrcEltName);
        }
        try {
            return new ExprAssigner(this).assign(rootExpr, context, value, keepSrcEltName);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "expression assignment failed", e);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault);
        }
    }

    protected FunctionContext createFunctionContext() {
        return FUNTION_LIBRARY;
    }

    protected Context getContext(Object o) {
        if (!(o instanceof BpelExecution)) {
            return super.getContext(o);
        }
        BpelExecution bpelExecution = (BpelExecution)o;
        ContextSupport support = this.getContextSupport();
        support.setVariableContext(new BpelVariableContext(bpelExecution));
        return new Context(support);
    }

    private static String assignVariable(VariableReferenceExpr rootExpr, Context context, Object value, boolean keepSrcEltName) {
        String variableName = rootExpr.getVariableName();
        BpelVariableContext variableContext = (BpelVariableContext)context.getContextSupport().getVariableContext();
        int dotIndex = variableName.indexOf(46);
        if (dotIndex == -1) {
            Variable variableDefinition = variableContext.findVariableDefinition(variableName);
            if (variableDefinition == null) {
                throw new OrchestraRuntimeException("variable not found: " + variableName);
            }
            if (variableDefinition.getMessageType() != null) {
                throw new OrchestraRuntimeException("illegal access to message variable: " + variableName);
            }
            variableContext.setValue(variableName, value);
            return variableName;
        }
        String messageName = variableName.substring(0, dotIndex);
        Variable variableDefinition = variableContext.findVariableDefinition(messageName);
        if (variableDefinition == null) {
            throw new OrchestraRuntimeException("variable not found: " + messageName);
        }
        Object valueForAssign = variableContext.getValueForAssign(messageName);
        if (variableDefinition.getMessageType() == null) {
            throw new OrchestraRuntimeException("illegal access to part of non-message variable: " + variableName);
        }
        MessageVariable messageValue = (MessageVariable)valueForAssign;
        String partName = variableName.substring(dotIndex + 1);
        messageValue.setPart(partName, value, keepSrcEltName);
        return messageName;
    }

    public boolean evaluateBoolean(BpelExecution bpelExecution) {
        return BooleanFunction.evaluate(this.evaluate(bpelExecution), null);
    }

    public XMLGregorianCalendar evaluateDeadline(BpelExecution bpelExecution) throws BpelFaultException {
        try {
            String s = StringFunction.evaluate(this.evaluate(bpelExecution), null);
            return datatypeFactory.newXMLGregorianCalendar(s);
        }
        catch (IllegalArgumentException iae) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, iae.getMessage(), iae);
        }
    }

    public Duration evaluateDuration(BpelExecution bpelExecution) throws BpelFaultException {
        try {
            String s = StringFunction.evaluate(this.evaluate(bpelExecution), null);
            return datatypeFactory.newDuration(s);
        }
        catch (IllegalArgumentException iae) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, iae.getMessage(), iae);
        }
    }

    public int evaluateUnsignedInt(BpelExecution bpelExecution) throws BpelFaultException {
        Double nb = NumberFunction.evaluate(this.evaluate(bpelExecution), null);
        if (nb.isNaN()) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, "Should be an Unsigned Integer expression that conforms to xsd:unsignedInt and got NaN", null);
        }
        int n = nb.intValue();
        if (n < 0) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.invalidExpressionValue, "Should be an Unsigned Integer expression that conforms to xsd:unsignedInt", null);
        }
        return n;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOG = Logger.getLogger(XPathExpressionEvaluator.class.getName());
        FUNTION_LIBRARY = XPathEvaluator.readFunctionLibrary();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExprAssigner
    extends ExprVisitor {
        private Context myContext;
        private Object result;
        private String variableName;
        private JaxenException jaxenException;
        private final XPathEvaluator xpathEvaluator;

        public ExprAssigner(XPathEvaluator xpathEvaluator) {
            this.xpathEvaluator = xpathEvaluator;
        }

        public String assign(Expr pathExpr, Context context, Object value, boolean keepSrcEltName) throws JaxenException {
            this.myContext = context;
            this.visit(pathExpr);
            if (this.jaxenException != null) {
                throw this.jaxenException;
            }
            Node node = null;
            node = this.result instanceof List ? this.xpathEvaluator.narrowToSingleNode((List)this.result) : (Node)this.result;
            BpelXmlUtil.setObjectValue(node, value, keepSrcEltName);
            return this.variableName;
        }

        @Override
        public void visit(FilterExpr filterExpr) {
            this.visit(filterExpr.getExpr());
            if (this.result instanceof List) {
                try {
                    this.result = this.evaluatePredicates(filterExpr.getPredicateSet(), (List)this.result, this.myContext.getContextSupport());
                }
                catch (JaxenException e) {
                    this.jaxenException = e;
                }
            }
        }

        @Override
        public void visit(LocationPath locationPath) {
            if (this.result instanceof List) {
                this.myContext.setNodeSet((List)this.result);
            } else {
                this.myContext.setNodeSet(Collections.singletonList(this.result));
            }
            try {
                this.result = this.xpathEvaluator.selectOrCreateNodes(locationPath, this.myContext);
            }
            catch (JaxenException e) {
                this.jaxenException = e;
            }
        }

        @Override
        public void visit(VariableReferenceExpr varExpr) {
            String variableName = varExpr.getVariableName();
            BpelVariableContext variableContext = (BpelVariableContext)this.myContext.getContextSupport().getVariableContext();
            int dotIndex = variableName.indexOf(46);
            if (dotIndex == -1) {
                Variable variableDefinition = variableContext.findVariableDefinition(variableName);
                if (variableDefinition == null) {
                    throw new OrchestraRuntimeException("variable not found: " + variableName);
                }
                this.result = variableContext.getValueForAssign(variableName);
                this.variableName = variableName;
            } else {
                String partName;
                String messageName = variableName.substring(0, dotIndex);
                Variable definition = variableContext.findVariableDefinition(messageName);
                if (definition == null) {
                    throw new OrchestraRuntimeException("variable not found: " + messageName);
                }
                if (definition.getMessageType() == null) {
                    throw new OrchestraRuntimeException("illegal access to part of non-message variable: " + variableName);
                }
                MessageVariable messageValue = (MessageVariable)variableContext.getValueForAssign(messageName);
                if (!messageValue.hasPart(partName = variableName.substring(dotIndex + 1))) {
                    throw new OrchestraRuntimeException("illegal access to message part " + partName);
                }
                this.result = messageValue.getPartValue(partName);
                this.variableName = messageName;
            }
        }

        @Override
        public void visit(LiteralExpr literalExpr) {
            try {
                this.result = literalExpr.evaluate(this.myContext);
            }
            catch (JaxenException e) {
                this.jaxenException = e;
            }
        }

        @Override
        public void visit(NumberExpr numberExpr) {
            try {
                this.result = numberExpr.evaluate(this.myContext);
            }
            catch (JaxenException e) {
                this.jaxenException = e;
            }
        }

        @Override
        public void visit(FunctionCallExpr callExpr) {
            try {
                this.result = callExpr.evaluate(this.myContext);
            }
            catch (JaxenException e) {
                this.jaxenException = e;
            }
        }

        private List<?> evaluatePredicates(PredicateSet predicateSet, List<?> nodes, ContextSupport support) throws JaxenException {
            List predicates = predicateSet.getPredicates();
            for (Predicate predicate : predicates) {
                nodes = predicateSet.applyPredicate(predicate, nodes, support);
            }
            return nodes;
        }
    }
}

