/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.osgi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.orchestra.osgi.ExtensionActivator;
import org.ow2.orchestra.osgi.OrchestraOSGiEngine;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraWSEngineActivator
extends ExtensionActivator {
    private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
    private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";
    protected ConfigurationAdmin configAdmin;
    private Configuration engineConfig;

    public OrchestraWSEngineActivator(BundleContext context, Class<?> ... extensions) {
        super(context, extensions);
    }

    public synchronized void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public synchronized void unsetConfigAdmin(ConfigurationAdmin configAdmin) throws IOException {
        if (this.engineConfig != null) {
            this.engineConfig.delete();
            this.engineConfig = null;
        }
        this.configAdmin = null;
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        URL envUrl = null;
        File envFile = new File(DEFAULT_ENV_CONFIG_FILE);
        if (envFile.exists()) {
            try {
                envUrl = envFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
        }
        if (envUrl == null) {
            envUrl = this.context.getBundle().getResource(DEFAULT_ENV_CONFIG_RESOURCE);
        }
        Misc.log(Level.INFO, "Environment will be taken from: %s", envUrl);
        this.engineConfig = this.configAdmin.createFactoryConfiguration(OrchestraOSGiEngine.class.getName(), null);
        Properties engineProperties = new Properties();
        engineProperties.setProperty("environmentLocation", envUrl.toExternalForm());
        this.engineConfig.update((Dictionary)engineProperties);
    }

    @Override
    public synchronized void stop() throws Exception {
        this.unsetConfigAdmin(this.configAdmin);
        super.stop();
    }
}

