/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.CatchActivity;
import org.ow2.orchestra.definition.activity.CatchAllActivity;
import org.ow2.orchestra.definition.activity.Compensate;
import org.ow2.orchestra.definition.activity.CompensationHandlerActivity;
import org.ow2.orchestra.definition.activity.Rethrow;
import org.ow2.orchestra.definition.activity.Sequence;
import org.ow2.orchestra.definition.activity.TerminationHandlerActivity;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BaseCatchFullDefinition;
import org.ow2.orchestra.facade.def.full.CatchAllFullDefinition;
import org.ow2.orchestra.facade.def.full.CatchFullDefinition;
import org.ow2.orchestra.facade.def.full.CompensationHandlerFullDefinition;
import org.ow2.orchestra.facade.def.full.ScopeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.TerminationHandlerFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.CatchAllFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.CatchFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.CompensateActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.CompensationHandlerFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.RethrowActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.SequenceActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.TerminationHandlerFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.runtime.FaultInCHHandler;
import org.ow2.orchestra.runtime.OrchestraFaultHandler;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityWithFCTHBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(ActivityWithFCTHBinding.class.getName());

    protected ActivityWithFCTHBinding(String tagName, ActivityType activityType) {
        super(tagName, activityType);
    }

    private AbstractBpelActivity fillActivity(Parse parse, AbstractBpelActivity activity) {
        activity.setName("autoGenerated_activity_" + activity.getClass().getSimpleName());
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), activity.getType(), activity.getName());
        activity.setUuid(activityDefinitionUUID);
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseTermination(Element element, Parse parse, Parser parser, NodeImpl scopeNode, ScopeActivityFullDefinition scopeActivityFullDefinition) {
        TerminationHandlerFullDefinition terminationHandlerDefinition;
        Element terminationHandlerElement = XmlUtil.element(element, "terminationHandler");
        if (terminationHandlerElement != null) {
            String name = "terminationHandler_" + scopeNode.getName();
            NodeImpl activity = scopeNode.createNode(name);
            parse.pushObject(activity);
            try {
                DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
                ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
                ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.CATCHALL_HANDLER, name);
                terminationHandlerDefinition = new TerminationHandlerFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
                definitionKeeper.setActivityFullDefinition(terminationHandlerDefinition);
                NodeImpl terminationHandlerActivity = this.parseChildActivity(terminationHandlerElement, parse, parser);
                TerminationHandlerActivity terminationHandlerBehavior = new TerminationHandlerActivity(terminationHandlerActivity, activityDefinitionUUID, name, scopeNode);
                activity.setBehaviour(terminationHandlerBehavior);
            }
            finally {
                parse.popObject();
            }
        } else {
            terminationHandlerDefinition = this.addDefaultTH(parse, scopeNode);
        }
        scopeActivityFullDefinition.setTerminationHandler(terminationHandlerDefinition);
    }

    protected TerminationHandlerFullDefinition addDefaultTH(Parse parse, NodeImpl scopeNode) {
        String name = "autoGenerated_DefaultTH_" + scopeNode.getName();
        NodeImpl activity = scopeNode.createNode(name);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.TERMINATION_HANDLER, name);
        NodeImpl compensate = activity.createNode(name + "_compensate");
        compensate.setBehaviour(this.fillActivity(parse, new Compensate()));
        CompensateActivityFullDefinitionImpl compensateActivityFullDefinition = new CompensateActivityFullDefinitionImpl((ProcessDefinitionUUID)processDefinitionUUID, ((AbstractBpelActivity)compensate.getBehaviour()).getUuid(), compensate.getName());
        TerminationHandlerActivity terminationHandlerBehavior = new TerminationHandlerActivity(compensate, activityDefinitionUUID, name, scopeNode);
        activity.setBehaviour(terminationHandlerBehavior);
        TerminationHandlerFullDefinitionImpl terminationHandlerFullDefinition = new TerminationHandlerFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
        terminationHandlerFullDefinition.setEnclosedActivity(compensateActivityFullDefinition);
        return terminationHandlerFullDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCompensation(Element element, Parse parse, Parser parser, NodeImpl scopeNode, ScopeActivityFullDefinition scopeActivityFullDefinition) {
        CompensationHandlerFullDefinition compensationHandlerDefinition;
        Element compensationHandlerElement = XmlUtil.element(element, "compensationHandler");
        if (compensationHandlerElement != null) {
            String name = "compensationHandler_" + scopeNode.getName();
            NodeImpl activity = scopeNode.createNode(name);
            parse.pushObject(activity);
            try {
                DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
                ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
                ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.CATCHALL_HANDLER, name);
                compensationHandlerDefinition = new CompensationHandlerFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
                definitionKeeper.setActivityFullDefinition(compensationHandlerDefinition);
                NodeImpl compensationHandlerActivity = this.parseChildActivity(compensationHandlerElement, parse, parser);
                CompensationHandlerActivity compensationHandlerBehavior = new CompensationHandlerActivity(compensationHandlerActivity, activityDefinitionUUID, name);
                activity.setBehaviour(compensationHandlerBehavior);
                activity.addExceptionHandler(new FaultInCHHandler());
            }
            finally {
                parse.popObject();
            }
        } else {
            compensationHandlerDefinition = this.addDefaultCH(parse, scopeNode);
        }
        scopeActivityFullDefinition.setCompensationHandler(compensationHandlerDefinition);
    }

    protected CompensationHandlerFullDefinition addDefaultCH(Parse parse, NodeImpl scopeNode) {
        String name = "autoGenerated_DefaultCH_" + scopeNode.getName();
        NodeImpl activity = scopeNode.createNode(name);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.COMPENSATION_HANDLER, name);
        NodeImpl compensate = activity.createNode(name + "_compensate");
        compensate.setBehaviour(this.fillActivity(parse, new Compensate()));
        CompensateActivityFullDefinitionImpl emptyActivityFullDefinition = new CompensateActivityFullDefinitionImpl((ProcessDefinitionUUID)processDefinitionUUID, ((AbstractBpelActivity)compensate.getBehaviour()).getUuid(), compensate.getName());
        CompensationHandlerActivity compensationHandlerBehavior = new CompensationHandlerActivity(compensate, activityDefinitionUUID, name);
        activity.setBehaviour(compensationHandlerBehavior);
        activity.addExceptionHandler(new FaultInCHHandler());
        CompensationHandlerFullDefinitionImpl compensationHandlerFullDefinition = new CompensationHandlerFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
        compensationHandlerFullDefinition.setEnclosedActivity(emptyActivityFullDefinition);
        return compensationHandlerFullDefinition;
    }

    protected int parseCatchAndCatchAll(Element faultHandlersElement, Parse parse, Parser parser, NodeImpl scopeNode, ScopeActivityFullDefinition scopeActivityFullDefinition) {
        int totalDefined = 0;
        ArrayList faultHandlers = new ArrayList();
        Element catchAllElement = XmlUtil.element(faultHandlersElement, "catchAll");
        if (catchAllElement != null) {
            CatchAllFullDefinition catchAllDefinition = this.parseCatchAll(catchAllElement, parse, parser, scopeNode);
            faultHandlers.add(catchAllDefinition);
            ++totalDefined;
        } else {
            BaseCatchFullDefinition<?> defaultFHDefinition = this.addDefaultFH(parse, scopeNode);
            faultHandlers.add(defaultFHDefinition);
        }
        List<Element> catchElements = XmlUtil.elements(faultHandlersElement, "catch");
        if (catchElements != null) {
            List<CatchFullDefinition> catchDefinitions = this.parseCatchs(catchElements, parse, parser, scopeNode);
            faultHandlers.addAll(catchDefinitions);
            totalDefined += catchDefinitions.size();
        }
        scopeActivityFullDefinition.setFaultHandlers(faultHandlers);
        scopeNode.addExceptionHandler(new OrchestraFaultHandler());
        return totalDefined;
    }

    protected BaseCatchFullDefinition<?> addDefaultFH(Parse parse, NodeImpl scopeNode) {
        String name = "autoGenerated_DefaultFH_" + scopeNode.getName();
        NodeImpl activity = scopeNode.createNode(name);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.CATCHALL_HANDLER, name);
        NodeImpl sequence = activity.createNode(name + "_sequence");
        sequence.setBehaviour(this.fillActivity(parse, new Sequence()));
        sequence.setPreviousNeeded(true);
        SequenceActivityFullDefinitionImpl sequenceActivityFullDefinition = new SequenceActivityFullDefinitionImpl((ProcessDefinitionUUID)processDefinitionUUID, ((AbstractBpelActivity)sequence.getBehaviour()).getUuid(), sequence.getName());
        NodeImpl compensate = sequence.createNode(name + "_compensate");
        compensate.setBehaviour(this.fillActivity(parse, new Compensate()));
        CompensateActivityFullDefinitionImpl compensateActivityFullDefinition = new CompensateActivityFullDefinitionImpl((ProcessDefinitionUUID)processDefinitionUUID, ((AbstractBpelActivity)compensate.getBehaviour()).getUuid(), compensate.getName());
        sequenceActivityFullDefinition.addEnclosedActivity(compensateActivityFullDefinition);
        NodeImpl rethrow = sequence.createNode(name + "_rethrow");
        rethrow.setBehaviour(this.fillActivity(parse, new Rethrow()));
        RethrowActivityFullDefinitionImpl rethrowActivityFullDefinition = new RethrowActivityFullDefinitionImpl((ProcessDefinitionUUID)processDefinitionUUID, ((AbstractBpelActivity)rethrow.getBehaviour()).getUuid(), rethrow.getName());
        sequenceActivityFullDefinition.addEnclosedActivity(rethrowActivityFullDefinition);
        CatchAllActivity catchAllBehavior = new CatchAllActivity(sequence, activityDefinitionUUID, name);
        activity.setBehaviour(catchAllBehavior);
        CatchAllFullDefinitionImpl catchAllFullDefinition = new CatchAllFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
        catchAllFullDefinition.setEnclosedActivity(sequenceActivityFullDefinition);
        return catchAllFullDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CatchAllFullDefinition parseCatchAll(Element catchAllElement, Parse parse, Parser parser, NodeImpl scopeNode) {
        String name = "catchAll_" + scopeNode.getName();
        NodeImpl activity = scopeNode.createNode(name);
        parse.pushObject(activity);
        try {
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
            ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.CATCHALL_HANDLER, name);
            CatchAllFullDefinitionImpl catchAllFullDefinition = new CatchAllFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
            definitionKeeper.setActivityFullDefinition(catchAllFullDefinition);
            NodeImpl catchAllActivity = this.parseChildActivity(catchAllElement, parse, parser);
            CatchAllActivity catchAllBehavior = new CatchAllActivity(catchAllActivity, activityDefinitionUUID, name);
            activity.setBehaviour(catchAllBehavior);
            CatchAllFullDefinitionImpl catchAllFullDefinitionImpl = catchAllFullDefinition;
            return catchAllFullDefinitionImpl;
        }
        finally {
            parse.popObject();
        }
    }

    private List<CatchFullDefinition> parseCatchs(List<Element> catchsElements, Parse parse, Parser parser, NodeImpl scopeNode) {
        ArrayList<CatchFullDefinition> result = new ArrayList<CatchFullDefinition>(catchsElements.size());
        for (Element catchElmt : catchsElements) {
            result.add(this.parseCatch(catchElmt, parse, parser, scopeNode));
        }
        for (int i = 0; i < result.size(); ++i) {
            for (int j = i + 1; j < result.size(); ++j) {
                if (!ActivityWithFCTHBinding.areEqual(((CatchFullDefinition)result.get(i)).getFaultName(), ((CatchFullDefinition)result.get(j)).getFaultName()) || !ActivityWithFCTHBinding.areEqual(((CatchFullDefinition)result.get(i)).getFaultMessageType(), ((CatchFullDefinition)result.get(j)).getFaultMessageType()) || !ActivityWithFCTHBinding.areEqual(((CatchFullDefinition)result.get(i)).getFaultElement(), ((CatchFullDefinition)result.get(j)).getFaultElement())) continue;
                String message = StaticAnalysisFault.getMessage("SA00093", "  Each <catch> element must be unique.");
                parse.addProblem(message, new StaticAnalysisException("SA00093"));
                return result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CatchFullDefinition parseCatch(Element catchElement, Parse parse, Parser parser, NodeImpl scopeNode) {
        String name = "catch_" + scopeNode.getName();
        NodeImpl activity = scopeNode.createNode(name);
        parse.pushObject(activity);
        try {
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
            ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), ActivityType.CATCH_HANDLER, name);
            CatchFullDefinitionImpl catch1 = new CatchFullDefinitionImpl(activityDefinitionUUID, (ProcessDefinitionUUID)processDefinitionUUID, name);
            catch1.setFaultName(XmlUtil.attributeQName(catchElement, "faultName"));
            catch1.setFaultVariable(this.createCatchVariable(catchElement, parse, parser));
            catch1.setFaultMessageType(XmlUtil.attributeQName(catchElement, "faultMessageType"));
            catch1.setFaultElement(XmlUtil.attributeQName(catchElement, "faultElement"));
            if (catch1.getFaultMessageType() != null && catch1.getFaultElement() != null) {
                String message = StaticAnalysisFault.getMessage("SA00081", "  The faultMessageType and faultElement attributes are mutually exclusive.");
                parse.addProblem(message, new StaticAnalysisException("SA00081"));
                CatchFullDefinition catchFullDefinition = null;
                return catchFullDefinition;
            }
            if (catch1.getFaultVariable() != null) {
                if (catch1.getFaultMessageType() == null && catch1.getFaultElement() == null) {
                    String message = StaticAnalysisFault.getMessage("SA00081", "  The faultVariable attribute must be accompanied by a faultMessageType or faultElement attribute.");
                    parse.addProblem(message, new StaticAnalysisException("SA00081"));
                    CatchFullDefinition catchFullDefinition = null;
                    return catchFullDefinition;
                }
            } else if (catch1.getFaultMessageType() != null || catch1.getFaultElement() != null) {
                String message = StaticAnalysisFault.getMessage("SA00081", "  The faultMessageType and faultElement attributes must be accompanied by a faultVariable attribute.");
                parse.addProblem(message, new StaticAnalysisException("SA00081"));
                CatchFullDefinition catchFullDefinition = null;
                return catchFullDefinition;
            }
            definitionKeeper.setActivityFullDefinition(catch1);
            NodeImpl catchActivity = this.parseChildActivity(catchElement, parse, parser);
            CatchActivity catchBehavior = new CatchActivity(catchActivity, activityDefinitionUUID, name, catch1, parse.findObject(BpelProcess.class).getWsdlInfos());
            activity.setBehaviour(catchBehavior);
            CatchFullDefinitionImpl catchFullDefinitionImpl = catch1;
            return catchFullDefinitionImpl;
        }
        finally {
            parse.popObject();
        }
    }

    private String createCatchVariable(Element catchElement, Parse parse, Parser parser) {
        String name = XmlUtil.attribute(catchElement, "faultVariable");
        if (name != null) {
            Variable variable = new Variable();
            variable.setMessageType(XmlUtil.attributeQName(catchElement, "faultMessageType"));
            variable.setElement(XmlUtil.attributeQName(catchElement, "faultElement"));
            if (!(variable.getElement() != null && variable.getMessageType() == null && variable.getXmlType() == null || variable.getElement() == null && variable.getMessageType() != null && variable.getXmlType() == null || variable.getElement() == null && variable.getMessageType() == null && variable.getXmlType() != null)) {
                String message = StaticAnalysisFault.getMessage("SA00025", "  Type of variable " + name + " not defined properly.");
                parse.addProblem(message, new StaticAnalysisException("SA00025"));
            }
            variable.initDefaultValue(parse.findObject(BpelProcess.class).getWsdlInfos());
        }
        return name;
    }

    private static boolean areEqual(Object e1, Object e2) {
        if (e1 == null) {
            return e2 == null;
        }
        return e1.equals(e2);
    }
}

