/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.persistence.db.DbRecorder;
import org.ow2.orchestra.persistence.db.hibernate.GenericEnumUserType;
import org.ow2.orchestra.pvm.internal.hibernate.HibernatePvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerierDbSessionImpl
extends HibernatePvmDbSession
implements QuerierDbSession {
    private static final Logger LOG = Logger.getLogger(QuerierDbSessionImpl.class.getName());
    private static Type processStateUserType = Hibernate.custom(GenericEnumUserType.class, new String[]{"enumClass"}, new String[]{ProcessState.class.getName()});
    private static Type processInstanceStateUserType = Hibernate.custom(GenericEnumUserType.class, new String[]{"enumClass"}, new String[]{ActivityState.class.getName()});

    public QuerierDbSessionImpl(Session session) {
        this.setSession(session);
        session.setFlushMode(FlushMode.COMMIT);
    }

    @Override
    public ActivityFullInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        Query query = this.getSession().getNamedQuery("findActivityInstanceByUUID");
        query.setString("uuid", activityInstanceUUID.toString());
        return (ActivityFullInstance)query.uniqueResult();
    }

    @Override
    public ProcessFullInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) {
        Query query = this.getSession().getNamedQuery("findProcessInstanceByUUID");
        query.setString("uuid", processInstanceUUID.toString());
        return (ProcessFullInstance)query.uniqueResult();
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstance(ProcessInstanceUUID processUUID) {
        Query query = this.getSession().getNamedQuery("findActivityInstancesWithProcessUUID");
        query.setString("processInstanceUUID", processUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<ActivityFullInstance>(results);
        }
        return new HashSet<ActivityFullInstance>();
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstance(ProcessInstanceUUID processInstanceUUID, ActivityState activityState) {
        Query query = this.getSession().getNamedQuery("findActivityInstancesWithProcessUUIDAndState");
        query.setString("activityState", activityState.toString());
        query.setString("processInstanceUUID", processInstanceUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<ActivityFullInstance>(results);
        }
        return new HashSet<ActivityFullInstance>();
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstance() {
        Query query = this.getSession().getNamedQuery("findProcessInstances");
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessFullInstance>(results);
        }
        return new HashSet<ProcessFullInstance>();
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstance(ProcessDefinitionUUID processDefinitionUUID) {
        Query query = this.getSession().getNamedQuery("findProcessInstancesWithProcessDefinitionUUID");
        query.setString("processDefinitionUUID", processDefinitionUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessFullInstance>(results);
        }
        return new HashSet<ProcessFullInstance>();
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstance(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) {
        Query query = this.getSession().getNamedQuery("findProcessInstancesWithProcessDefinitionUUIDAndState");
        query.setString("processInstanceState", processInstanceState.toString());
        query.setString("processDefinitionUUID", processDefinitionUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessFullInstance>(results);
        }
        return new HashSet<ProcessFullInstance>();
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstance(ActivityState processInstanceState) {
        Query query = this.getSession().getNamedQuery("findProcessInstancesWithState");
        query.setString("processInstanceState", processInstanceState.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessFullInstance>(results);
        }
        return new HashSet<ProcessFullInstance>();
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinition(QName name, ProcessState state) {
        Query query = this.getSession().getNamedQuery("findProcessDefinitionWithQNameAndState");
        query.setString("name", name.getLocalPart());
        query.setString("nameSpace", name.getNamespaceURI());
        query.setParameter("state", (Object)state, processStateUserType);
        List results = query.list();
        if (results != null) {
            return new ArrayList<ProcessFullDefinition>(results);
        }
        return new ArrayList<ProcessFullDefinition>();
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinition(QName name) {
        Query query = this.getSession().getNamedQuery("findProcessDefinitionWithQName");
        query.setString("name", name.getLocalPart());
        query.setString("nameSpace", name.getNamespaceURI());
        List results = query.list();
        if (results != null) {
            return new ArrayList<ProcessFullDefinition>(results);
        }
        return new ArrayList<ProcessFullDefinition>();
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinition(ProcessState state) {
        Query query = this.getSession().getNamedQuery("findProcessDefinitionWithState");
        query.setParameter("state", (Object)state, processStateUserType);
        List results = query.list();
        if (results != null) {
            return new ArrayList<ProcessFullDefinition>(results);
        }
        return new ArrayList<ProcessFullDefinition>();
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinition() {
        Query query = this.getSession().getNamedQuery("findProcessDefinition");
        List results = query.list();
        if (results != null) {
            return new ArrayList<ProcessFullDefinition>(results);
        }
        return new ArrayList<ProcessFullDefinition>();
    }

    @Override
    public ProcessFullDefinition getProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        Query query = this.getSession().getNamedQuery("findProcessDefinitionByUUID");
        query.setString("uuid", processDefinitionUUID.toString());
        return (ProcessFullDefinition)query.uniqueResult();
    }

    @Override
    public ActivityFullDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) {
        Query query = this.getSession().getNamedQuery("findActivityDefinitionByUUID");
        query.setString("uuid", activityDefinitionUUID.toString());
        return (ActivityFullDefinition)query.uniqueResult();
    }

    @Override
    public List<DbRecorder.Record> getAllRecords(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().createQuery("select rec from org.ow2.orchestra.persistence.db.DbRecorder$Record as rec where rec.processInstanceUUID.value = :uuid order by rec.dbid");
        query.setString("uuid", instanceUUID.toString());
        return query.list();
    }

    @Override
    public List<DbRecorder.Record> getAllActivityRecords(ActivityInstanceUUID activityInstanceUUID) {
        Query query = this.getSession().createQuery("select rec from org.ow2.orchestra.persistence.db.DbRecorder$Record as rec where rec.activityInstanceUUID.value = :uuid  order by rec.dbid");
        query.setString("uuid", activityInstanceUUID.toString());
        return query.list();
    }

    @Override
    public Collection<ProcessInstanceUUID> getAllProcessInstanceUUIDsFromRecords() {
        Query query = this.getSession().createQuery("select distinct rec.processInstanceUUID from org.ow2.orchestra.persistence.db.DbRecorder$Record as rec");
        return query.list();
    }

    @Override
    public Collection<ProcessInstanceUUID> getAllProcessInstanceUUIDsFromRecords(ProcessDefinitionUUID processDefinitionUUID) {
        Query query = this.getSession().createQuery("select distinct rec.processInstanceUUID from org.ow2.orchestra.persistence.db.DbRecorder$Record as rec where rec.processDefinitionUUID = :uuid");
        query.setString("uuid", processDefinitionUUID.toString());
        return query.list();
    }
}

