/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.db.hibernate.NodeType;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class ElementType
extends NodeType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        String columnName = names[0];
        Reader reader = null;
        try {
            Element element;
            reader = rs.getCharacterStream(columnName);
            if (reader == null) {
                Object var6_6 = null;
                return var6_6;
            }
            Element element2 = element = XmlUtil.getDocumentFromReader(reader).getDocumentElement();
            return element2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        if (value == null) {
            st.setNull(index, NodeType.SQL_TYPES[0]);
        } else {
            Element element = (Element)value;
            try {
                ByteArrayOutputStream byteStream = XmlUtil.getNodeAsBAOS(element);
                StringReader sr = new StringReader(byteStream.toString());
                st.setCharacterStream(index, (Reader)sr, byteStream.size());
            }
            catch (OrchestraRuntimeException e) {
                Class<?> clazz = value.getClass();
                if (e.getCause() != null && e.getCause() instanceof ClassCastException && clazz.getName().startsWith("org.apache.axis.message.")) {
                    StringReader sr = new StringReader(value.toString());
                    st.setCharacterStream(index, (Reader)sr, value.toString().length());
                }
                throw e;
            }
        }
    }

    public Class returnedClass() {
        return Element.class;
    }
}

