/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Archiver;

public class LoggerArchiver
implements Archiver {
    public static final Logger LOG = Logger.getLogger(LoggerArchiver.class.getName());
    private final Level level;

    public LoggerArchiver() {
        this(Level.FINE);
    }

    public LoggerArchiver(String levelName) {
        this(Level.parse(levelName));
    }

    public LoggerArchiver(final Level level) {
        this.level = level;
        Transaction tx = Environment.getFromCurrent(Transaction.class);
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (status == 3) {
                    LOG.log(level, "Transaction committed");
                } else {
                    LOG.log(level, "Transaction rolledback");
                }
            }
        });
    }

    private void log(Archivable archivable) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Archiving: " + archivable);
        }
    }

    public void archive(Archivable archivable) {
        this.log(archivable);
    }

    public void remove(Archivable archivable) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Deleting from archive: " + archivable);
        }
    }
}

