/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.hibernate;

import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.util.StringHelper;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;

public class PvmNamingStrategy
extends ImprovedNamingStrategy {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(PvmNamingStrategy.class.getName());
    private String prefix;

    public PvmNamingStrategy(String prefix) {
        if (!"".equals(prefix)) {
            this.prefix = prefix;
        }
    }

    public String classToTableName(String className) {
        String name = ReflectUtil.getUnqualifiedClassName(className);
        if (name.endsWith("Impl")) {
            name = name.substring(0, name.length() - 4);
        }
        name = this.prefix + name.toUpperCase();
        if (LOG.isTraceEnabled()) {
            LOG.trace("classToTableName(" + className + ") ==> " + name);
        }
        return name;
    }

    public String tableName(String tableName) {
        if (this.prefix != null) {
            return this.prefix + tableName;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("tableName(" + tableName + ") ==> " + tableName);
        }
        return tableName;
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        String name = StringHelper.unqualify(propertyName);
        name = this.prefix + name.toUpperCase() + "_";
        if (LOG.isTraceEnabled()) {
            LOG.trace("collectionTableName(" + ownerEntity + ", " + ownerEntityTable + ", " + associatedEntity + ", " + associatedEntityTable + ", " + propertyName + ") ==> " + name);
        }
        return name;
    }

    public String propertyToColumnName(String propertyName) {
        String name = propertyName;
        name = StringHelper.unqualify(name);
        name = name.toUpperCase() + "_";
        if (LOG.isTraceEnabled()) {
            LOG.trace("propertyToColumnName(" + propertyName + ") ==> " + name);
        }
        return name;
    }

    public String logicalColumnName(String columnName, String propertyName) {
        String name = columnName != null ? columnName : propertyName;
        name = name.replace('.', '_');
        if (!(name = name.toUpperCase()).endsWith("_")) {
            name = name + "_";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("logicalColumnName(" + columnName + ", " + propertyName + ") ==> " + name);
        }
        return name;
    }

    public String columnName(String columnName) {
        String name = columnName.toUpperCase();
        if (LOG.isTraceEnabled()) {
            LOG.trace("columnName(" + columnName + ") ==> " + name);
        }
        return name;
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String name = super.foreignKeyColumnName(propertyName, propertyEntityName, propertyTableName, referencedColumnName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("foreignKeyColumnName(" + propertyName + ", " + propertyEntityName + ", " + propertyTableName + ", " + referencedColumnName + ") ==> " + name);
        }
        return name;
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        String name = super.logicalCollectionColumnName(columnName, propertyName, referencedColumn);
        if (LOG.isTraceEnabled()) {
            LOG.trace("logicalCollectionColumnName(" + columnName + ", " + propertyName + ", " + referencedColumn + ") ==> " + name);
        }
        return name;
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        String name = super.logicalCollectionTableName(tableName, ownerEntityTable, associatedEntityTable, propertyName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("logicalCollectionTableName(" + tableName + ", " + ownerEntityTable + ", " + associatedEntityTable + ", " + propertyName + ") ==> " + name);
        }
        return name;
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        String name = super.joinKeyColumnName(joinedColumn, joinedTable);
        if (LOG.isTraceEnabled()) {
            LOG.trace("joinKeyColumnName(" + joinedColumn + ", " + joinedTable + ") ==> " + name);
        }
        return name;
    }
}

