/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor.pvm;

import java.util.Collection;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractDispatcherThread;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherThread
extends AbstractDispatcherThread {
    private static final Log LOG = Log.getLog(DispatcherThread.class.getName());
    private final PvmJobExecutor jobExecutor;

    DispatcherThread(PvmJobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    DispatcherThread(PvmJobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    @Override
    protected void putAcquiredJobDbidsOnQueue(Collection<JobImpl<?>> acquiredJobDbids) {
        LOG.debug("pushing jobs on the queue " + acquiredJobDbids);
        while (acquiredJobDbids != null) {
            try {
                this.jobExecutor.getJobDbidsQueue().put(acquiredJobDbids);
                LOG.trace("jobs " + acquiredJobDbids + " were put on the queue");
                acquiredJobDbids = null;
            }
            catch (InterruptedException e) {
                LOG.trace("putting acquired jobImpl dbids got interrupted. retrying...");
            }
        }
    }

    @Override
    public PvmJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }
}

