/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.activity.ActivityExecution;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.client.ClientProcessInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.job.TimerImpl;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.CommentImpl;
import org.ow2.orchestra.pvm.internal.model.CompositeElementImpl;
import org.ow2.orchestra.pvm.internal.model.EventImpl;
import org.ow2.orchestra.pvm.internal.model.EventListenerReference;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ObservableElementImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessModificationsImpl;
import org.ow2.orchestra.pvm.internal.model.TimerDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.TransitionImpl;
import org.ow2.orchestra.pvm.internal.model.VariableDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.op.AtomicOperation;
import org.ow2.orchestra.pvm.internal.model.op.ExecuteNode;
import org.ow2.orchestra.pvm.internal.model.op.MoveToChildNode;
import org.ow2.orchestra.pvm.internal.model.op.MoveToParentNode;
import org.ow2.orchestra.pvm.internal.model.op.ProceedToDestination;
import org.ow2.orchestra.pvm.internal.model.op.Signal;
import org.ow2.orchestra.pvm.internal.model.op.TakeTransition;
import org.ow2.orchestra.pvm.internal.type.Converter;
import org.ow2.orchestra.pvm.internal.type.Type;
import org.ow2.orchestra.pvm.internal.type.Variable;
import org.ow2.orchestra.pvm.internal.type.VariableTypeResolver;
import org.ow2.orchestra.pvm.internal.type.variable.NullVariable;
import org.ow2.orchestra.pvm.internal.type.variable.UnpersistableVariable;
import org.ow2.orchestra.pvm.internal.util.Clock;
import org.ow2.orchestra.pvm.internal.util.EqualsUtil;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.pvm.listener.EventListener;
import org.ow2.orchestra.pvm.listener.EventListenerExecution;
import org.ow2.orchestra.pvm.model.Comment;
import org.ow2.orchestra.pvm.model.Event;
import org.ow2.orchestra.pvm.model.IdGenerator;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.pvm.model.ObservableElement;
import org.ow2.orchestra.pvm.model.OpenExecution;
import org.ow2.orchestra.pvm.model.Transition;
import org.ow2.orchestra.pvm.processlog.ProcessLog;
import org.ow2.orchestra.pvm.session.LogSession;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.pvm.session.TimerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionImpl
implements ClientProcessInstance,
ActivityExecution,
EventListenerExecution,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(Execution.class.getName());
    public static final AtomicOperation EXECUTE_NODE = new ExecuteNode();
    public static final AtomicOperation PROCEED_TO_DESTINATION = new ProceedToDestination();
    public static final AtomicOperation TAKE_TRANSITION = new TakeTransition();
    public static final AtomicOperation PROPAGATE_TO_PARENT = new MoveToParentNode();
    protected long dbid;
    protected int dbversion;
    protected String name;
    protected String key;
    protected String id;
    protected String state;
    protected ProcessDefinitionImpl processDefinition;
    protected NodeImpl node;
    protected TransitionImpl transition;
    protected NodeImpl transitionOrigin;
    protected EventImpl event;
    protected ObservableElementImpl eventSource;
    protected Collection<ExecutionImpl> executions;
    protected ExecutionImpl parent = null;
    protected ExecutionImpl processInstance;
    protected boolean hasVariables;
    protected Map<String, Variable> variables;
    protected List<JobImpl<?>> jobs = new ArrayList();
    protected ExecutionImpl superProcessExecution;
    protected ExecutionImpl subProcessInstance;
    protected Set<CommentImpl> comments;
    protected int priority = 0;
    protected int nextLogIndex;
    protected transient Map<String, OpenExecution> executionsMap = null;
    protected Queue<AtomicOperation> atomicOperations;
    protected Propagation propagation = null;
    protected Node previousNode;
    protected Transition previousTransition;
    protected Exception exception;
    protected ProcessModificationsImpl processModifications;

    public void initializeProcessInstance(ProcessDefinitionImpl processDefinition, String key) {
        this.processDefinition = processDefinition;
        this.node = processDefinition.getInitial();
        this.processInstance = this;
        this.state = "created";
        this.key = key;
        IdGenerator keyGenerator = Environment.getFromCurrent(IdGenerator.class, false);
        if (keyGenerator != null) {
            this.id = keyGenerator.createId(processDefinition, null, this);
        }
    }

    @Override
    public void begin() {
        if (this.state != "created") {
            throw new PvmException(this.toString() + " is already begun: " + this.state);
        }
        ExecutionImpl scopedExecution = this.initializeScopes();
        this.state = "active";
        this.fire("process-begin", this.processDefinition);
        if (this.node != null) {
            scopedExecution.performAtomicOperation(EXECUTE_NODE);
        }
    }

    protected ExecutionImpl initializeScopes() {
        LinkedList<NodeImpl> enteredNodes = new LinkedList<NodeImpl>();
        NodeImpl initial = this.processDefinition.getInitial();
        ExecutionImpl scopedExecution = null;
        if (initial != null) {
            enteredNodes.add(initial);
            for (NodeImpl parentNode = initial.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                enteredNodes.addFirst(parentNode);
            }
            scopedExecution = this;
            this.initializeVariables(this.processDefinition, this);
            this.initializeTimers(this.processDefinition);
            for (NodeImpl enteredNode : enteredNodes) {
                if (!enteredNode.isLocalScope()) continue;
                scopedExecution.setNode(enteredNode);
                scopedExecution = scopedExecution.createScope(enteredNode);
            }
            scopedExecution.setNode(initial);
        }
        return scopedExecution;
    }

    public ExecutionImpl createScope(CompositeElementImpl scope) {
        ExecutionImpl child = this.createExecution(scope.getName());
        child.setNode(this.getNode());
        child.setTransition(this.getTransition());
        child.setPropagation(this.getPropagation());
        child.setTransitionOrigin(this.getTransitionOrigin());
        child.setPreviousTransition(this.getPreviousTransition());
        child.setPreviousNode(this.getPreviousNode());
        child.initializeVariables(scope, this);
        child.initializeTimers(scope);
        return child;
    }

    public ExecutionImpl destroyScope(CompositeElementImpl scope) {
        this.destroyTimers(scope);
        this.destroyVariables(scope, this.parent);
        this.getParent().setNode(this.getNode());
        this.getParent().setTransition(this.getTransition());
        this.getParent().setPropagation(this.getPropagation());
        this.getParent().setTransitionOrigin(this.getTransitionOrigin());
        this.getParent().setPreviousTransition(this.getPreviousTransition());
        this.getParent().setPreviousNode(this.getPreviousNode());
        this.end();
        this.parent.removeExecution(this);
        return this.parent;
    }

    public String toString() {
        if (this.name != null) {
            return "execution[" + this.name + "]";
        }
        if (this.parent == null) {
            return "process-instance";
        }
        return "execution";
    }

    @Override
    public void end() {
        this.end("ended");
    }

    @Override
    public void end(String state) {
        if (state == null) {
            throw new PvmException("state is null");
        }
        if (state.equals("active") || state.equals("created") || state.equals("inactive") || state.equals("suspended") || state.equals("async")) {
            throw new PvmException("invalid end state: " + state);
        }
        if (LOG.isDebugEnabled()) {
            if (state == "ended") {
                LOG.debug(this.toString() + " ends");
            } else {
                LOG.debug(this.toString() + " ends with state " + state);
            }
        }
        if (this.executions != null) {
            for (ExecutionImpl child : this.executions) {
                child.end(state);
            }
        }
        this.lock(state);
        this.propagation = Propagation.EXPLICIT;
        if (this.parent == null) {
            this.fire("process-end", this.processDefinition);
            if (this.superProcessExecution != null) {
                LOG.trace(this.toString() + " signals super process execution");
                this.superProcessExecution.signal();
            }
        }
    }

    @Override
    public void cancel() {
        this.end("cancelled");
    }

    @Override
    public void suspend() {
        if (this.isSuspended()) {
            throw new PvmException(this.toString() + " is suspended");
        }
        this.lock("suspended");
    }

    @Override
    public void resume() {
        if (!this.isSuspended()) {
            throw new PvmException(this.toString() + " is not suspended");
        }
        this.unlock();
    }

    @Override
    public void signal() {
        this.signal(null, (Map<String, Object>)null);
    }

    @Override
    public void signal(String signal) {
        this.signal(signal, (Map<String, Object>)null);
    }

    @Override
    public void signal(Map<String, Object> parameters) {
        this.signal(null, parameters);
    }

    @Override
    public void signal(String signal, Map<String, Object> parameters) {
        this.checkLock();
        if (this.node != null) {
            this.performAtomicOperation(new Signal(signal, parameters, this.node));
        } else if (this.transition != null) {
            this.performAtomicOperation(PROCEED_TO_DESTINATION);
        } else {
            throw new PvmException("execution is not in a node or in a transition");
        }
    }

    @Override
    public void signal(Execution execution) {
        ((ExecutionImpl)execution).signal(null, (Map<String, Object>)null);
    }

    @Override
    public void signal(String signalName, Execution execution) {
        ((ExecutionImpl)execution).signal(signalName, (Map<String, Object>)null);
    }

    @Override
    public void signal(Map<String, Object> parameters, Execution execution) {
        ((ExecutionImpl)execution).signal(null, parameters);
    }

    @Override
    public void signal(String signalName, Map<String, Object> parameters, Execution execution) {
        ((ExecutionImpl)execution).signal(signalName, parameters);
    }

    @Override
    public void takeDefaultTransition() {
        TransitionImpl defaultTransition = this.node.getDefaultTransition();
        if (defaultTransition == null) {
            throw new PvmException("there is no default transition in " + this.node);
        }
        this.take(defaultTransition);
    }

    @Override
    public void take(String transitionName) {
        if (this.node == null) {
            throw new PvmException(this.toString() + " is not positioned in node");
        }
        TransitionImpl transitionToTake = this.findTransition(transitionName);
        if (transitionToTake == null) {
            throw new PvmException("there is no transition " + transitionName + " in " + this.node);
        }
        this.take(transitionToTake);
    }

    @Override
    public void take(Transition transitionToTake) {
        this.checkLock();
        this.setPropagation(Propagation.EXPLICIT);
        this.setTransition((TransitionImpl)transitionToTake);
        this.setTransitionOrigin(this.getNode());
        this.setPreviousTransition(null);
        this.performAtomicOperation(TAKE_TRANSITION);
    }

    @Override
    public void take(Transition transitionToTake, Execution execution) {
        ((ExecutionImpl)execution).take(transitionToTake);
    }

    @Override
    public void execute(String nodeName) {
        if (this.node == null) {
            throw new PvmException("node is null");
        }
        NodeImpl nestedNode = this.node.getNode(nodeName);
        if (nestedNode == null) {
            throw new PvmException("node " + nodeName + " doesn't exist in " + this.node);
        }
        this.execute(nestedNode);
    }

    @Override
    public void execute(Node node) {
        if (node == null) {
            throw new PvmException("node is null");
        }
        this.checkLock();
        this.propagation = Propagation.EXPLICIT;
        this.performAtomicOperation(new MoveToChildNode((NodeImpl)node));
    }

    @Override
    public void waitForSignal() {
        this.propagation = Propagation.WAIT;
    }

    public void proceed() {
        this.checkLock();
        TransitionImpl defaultTransition = this.findDefaultTransition();
        if (defaultTransition != null) {
            this.take(defaultTransition);
        } else {
            NodeImpl parentNode = this.node.getParentNode();
            if (parentNode != null) {
                this.performAtomicOperation(PROPAGATE_TO_PARENT);
            } else {
                this.end();
            }
        }
    }

    @Override
    public void move(Node destination, Execution execution) {
        ((ExecutionImpl)execution).move(destination);
    }

    @Override
    public void move(Node destination) {
        this.checkLock();
        this.setNode((NodeImpl)destination);
    }

    public void moveTo(NodeImpl destination) {
        if (destination.isPreviousNeeded()) {
            this.setPreviousNode(this.getNode());
            this.setPreviousTransition(this.getTransition());
        } else {
            this.previousNode = null;
            this.previousTransition = null;
        }
        this.node = destination;
        this.transition = null;
        this.transitionOrigin = null;
    }

    public ExecutionImpl beginNode(NodeImpl node) {
        ExecutionImpl propagatingExecution = this;
        if (node.isLocalScope()) {
            propagatingExecution = this.createScope(node);
        }
        this.fire("node-begin", node);
        return propagatingExecution;
    }

    public ExecutionImpl endNode(NodeImpl node) {
        ExecutionImpl propagatingExecution = this;
        this.fire("node-end", node);
        if (node.isLocalScope()) {
            propagatingExecution = this.destroyScope(node);
        }
        return propagatingExecution;
    }

    public synchronized void performAtomicOperation(AtomicOperation operation) {
        if (operation.isAsync(this)) {
            this.sendContinuationMessage(operation);
        } else {
            this.performAtomicOperationSync(operation);
        }
    }

    protected void initializeVariables(CompositeElementImpl scope, ExecutionImpl outerExecution) {
        List<VariableDefinitionImpl> variableDefinitions = scope.getVariableDefinitions();
        if (!variableDefinitions.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("initializing variables in scope " + scope);
            }
            this.variables = new HashMap<String, Variable>();
            for (VariableDefinitionImpl variableDefinition : variableDefinitions) {
                String key = variableDefinition.getKey();
                Object value = variableDefinition.getSourceValue(outerExecution);
                Type type = variableDefinition.getType();
                this.createVariable(key, value, type);
            }
        }
    }

    protected void destroyVariables(CompositeElementImpl scope, ExecutionImpl outerExecution) {
        List<VariableDefinitionImpl> variableDefinitions = scope.getVariableDefinitions();
        if (variableDefinitions != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("destroying var scope " + scope);
            }
            for (VariableDefinitionImpl variableDefinition : variableDefinitions) {
                String destination = variableDefinition.getDestination();
                if (destination == null) continue;
                String key = variableDefinition.getKey();
                Object value = variableDefinition.getDestinationValue(this);
                outerExecution.setVariable(key, value);
            }
        }
    }

    @Override
    public void createVariable(String key, Object value) {
        this.createVariable(key, value, null, null);
    }

    @Override
    public void createVariable(String key, Object value, String typeName) {
        this.createVariable(key, value, typeName, null);
    }

    public void createVariable(String key, Object value, Type type) {
        this.createVariable(key, value, null, type);
    }

    public void createVariable(String key, Object value, String typeName, Type type) {
        VariableTypeResolver variableTypeResolver;
        Environment environment;
        if (this.isFinished()) {
            throw new PvmException("can't create variable '" + key + "' on " + this + ": " + this.state);
        }
        LOG.debug("create variable '" + key + "' in '" + this + "' with value '" + value + "'");
        if (type == null && (environment = Environment.getCurrent()) != null && (variableTypeResolver = environment.get(VariableTypeResolver.class)) != null) {
            if (typeName != null) {
                type = variableTypeResolver.findTypeByName(typeName);
            }
            if (type == null) {
                type = variableTypeResolver.findTypeByMatch(key, value);
            }
        }
        Variable variable = null;
        if (type != null) {
            Class<?> variableClass = type.getVariableClass();
            try {
                LOG.trace("creating new " + type + " variable " + key);
                variable = (Variable)variableClass.newInstance();
            }
            catch (Exception e) {
                throw new PvmException("couldn't instantiate variable instance class '" + variableClass.getName() + "'");
            }
            Converter converter = type.getConverter();
            variable.setConverter(converter);
        } else if (value == null) {
            LOG.trace("creating null variable for " + key);
            variable = new NullVariable();
        } else {
            LOG.trace("creating new unpersistable variable for " + key);
            variable = new UnpersistableVariable();
        }
        variable.setKey(key);
        variable.setValue(value);
        variable.setProcessInstance(this.processInstance);
        if (this.variables == null) {
            this.variables = new HashMap<String, Variable>();
        }
        this.variables.put(variable.getKey(), variable);
        this.hasVariables = true;
    }

    @Override
    public void setVariable(String key, Object value) {
        if (this.isFinished()) {
            throw new PvmException("can't update variable '" + key + "' on " + this + ": " + this.state);
        }
        Variable variable = this.getVariableObject(key);
        if (variable != null && !variable.supports(value)) {
            LOG.debug("variable type change. deleting '" + key + "' from '" + this + "'");
            this.removeVariable(key);
            variable = null;
        }
        if (variable != null) {
            LOG.debug("updating variable '" + key + "' in '" + this + "' to value '" + value + "'");
            variable.setValue(value);
        } else if (this.parent == null) {
            this.createVariable(key, value, null, null);
        } else {
            this.parent.setVariable(key, value);
        }
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        if (variables != null) {
            for (String key : variables.keySet()) {
                Object value = variables.get(key);
                this.setVariable(key, value);
            }
        }
    }

    @Override
    public Object getVariable(String key) {
        Object value = null;
        Variable variable = this.getVariableObject(key);
        if (variable != null) {
            return variable.getValue();
        }
        if (this.parent != null) {
            return this.parent.getVariable(key);
        }
        return null;
    }

    public Variable getVariableObject(String key) {
        return this.hasVariables ? this.variables.get(key) : null;
    }

    @Override
    public boolean hasVariable(String key) {
        return this.hasVariables && this.variables.containsKey(key) || this.parent != null && this.parent.hasVariable(key);
    }

    @Override
    public Set<String> getVariableKeys() {
        Set<String> variableKeys = null;
        variableKeys = this.parent != null ? this.parent.getVariableKeys() : new HashSet<String>();
        if (this.hasVariables) {
            variableKeys.addAll(this.variables.keySet());
        }
        return variableKeys;
    }

    @Override
    public Map<String, Object> getVariables() {
        Map<String, Object> values = null;
        values = this.parent != null ? this.parent.getVariables() : new HashMap<String, Object>();
        if (this.hasVariables) {
            for (Map.Entry<String, Variable> entry : this.variables.entrySet()) {
                String name = entry.getKey();
                Variable variable = entry.getValue();
                Object value = variable.getValue();
                values.put(name, value);
            }
        }
        return values;
    }

    @Override
    public boolean hasVariables() {
        return this.hasVariables || this.parent != null && this.parent.hasVariables();
    }

    @Override
    public boolean removeVariable(String key) {
        if (this.isFinished()) {
            throw new PvmException("can't remove variable '" + key + "' on " + this + ": " + this.state);
        }
        Variable variable = null;
        if (this.hasVariables) {
            variable = this.variables.remove(key);
            if (this.variables.isEmpty()) {
                this.hasVariables = false;
            }
            if (variable != null) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.removeVariable(key);
        }
        return false;
    }

    @Override
    public void removeVariables() {
        if (this.hasVariables) {
            this.variables.clear();
        }
        this.hasVariables = false;
    }

    protected void initializeTimers(CompositeElementImpl scope) {
        Set<TimerDefinitionImpl> timerDefinitions = scope.getTimerDefinitions();
        if (!timerDefinitions.isEmpty()) {
            this.jobs = new ArrayList();
            for (TimerDefinitionImpl timerDefinition : timerDefinitions) {
                this.createTimer(timerDefinition.getEventName(), timerDefinition.getSignalName(), timerDefinition.getDueDateDescription(), timerDefinition.getDueDate(), timerDefinition.getRepeat(), timerDefinition.isExclusive(), timerDefinition.getRetries());
            }
        }
    }

    protected void destroyTimers(CompositeElementImpl scope) {
        LOG.debug("destroying timers of " + this.toString());
        if (this.jobs != null && !this.jobs.isEmpty()) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new PvmException("non environment for initializing timers");
            }
            TimerSession timerSession = environment.get(TimerSession.class);
            if (timerSession == null) {
                throw new PvmException("no TimerSession in environment for initializing timers");
            }
            HashSet jobsSnapshot = new HashSet(this.jobs);
            for (Job job : jobsSnapshot) {
                if (!(job instanceof TimerImpl)) continue;
                timerSession.cancel((TimerImpl)job);
                this.jobs.remove(job);
            }
        }
    }

    public void createTimer(String eventName, String signalName, String dueDateDescription) {
        this.createTimer(eventName, signalName, dueDateDescription, null, null, null, null);
    }

    public void createTimer(String eventName, String signalName, String dueDateDescription, String repeat) {
        this.createTimer(eventName, signalName, dueDateDescription, null, repeat, null, null);
    }

    public void createTimer(String eventName, String signalName, String dueDateDescription, Date dueDate, String repeat, Boolean isExclusive, Integer retries) {
        Environment environment;
        if (eventName == null && signalName == null) {
            throw new PvmException("no event or signal specified");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating timer on " + this.toString());
        }
        TimerImpl timerImpl = this.instantiateTimer();
        timerImpl.setExecution(this);
        this.jobs.add(timerImpl);
        timerImpl.setEventName(eventName);
        timerImpl.setSignalName(signalName);
        if (dueDate != null) {
            timerImpl.setDueDate(dueDate);
        } else {
            timerImpl.setDueDateDescription(dueDateDescription);
        }
        if (isExclusive != null) {
            timerImpl.setExclusive(isExclusive);
        }
        if (retries != null) {
            timerImpl.setRetries(retries);
        }
        if (repeat != null) {
            timerImpl.setRepeat(repeat);
        }
        if ((environment = Environment.getCurrent()) == null) {
            throw new PvmException("non environment for initializing timers");
        }
        TimerSession timerSession = environment.get(TimerSession.class);
        if (timerSession == null) {
            throw new PvmException("no TimerSession in environment for initializing timers");
        }
        timerSession.schedule(timerImpl);
    }

    @Override
    public List<Job> getJobs() {
        return this.jobs;
    }

    protected TimerImpl instantiateTimer() {
        return new TimerImpl();
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void lock(String state) {
        if (state == null) {
            throw new PvmException("given state is null");
        }
        this.checkLock();
        LOG.trace("locking " + this);
        this.state = state;
    }

    public void unlock() {
        if ("active".equals(this.state)) {
            throw new PvmException("state is already active");
        }
        LOG.trace("unlocking " + this);
        this.state = "active";
    }

    @Override
    public boolean isActive() {
        return "active".equals(this.state);
    }

    @Override
    public boolean isLocked() {
        return !this.isActive();
    }

    @Override
    public boolean isSuspended() {
        return "suspended".equals(this.state);
    }

    @Override
    public boolean isEnded() {
        return "ended".equals(this.state);
    }

    @Override
    public boolean isFinished() {
        return "ended".equals(this.state) || "cancelled".equals(this.state);
    }

    protected void checkLock() {
        if (!"active".equals(this.state)) {
            throw new PvmException(this.toString() + " is not active: " + this.state);
        }
    }

    public void sendContinuationMessage(AtomicOperation operation) {
        Environment environment = Environment.getCurrent();
        MessageSession messageSession = environment.get(MessageSession.class);
        if (messageSession == null) {
            throw new PvmException("no message-session configured to send asynchronous continuation message");
        }
        MessageImpl<?> asyncMessage = operation.createAsyncMessage(this);
        this.lock("async");
        messageSession.send(asyncMessage);
    }

    public void performAtomicOperationSync(AtomicOperation operation) {
        if (this.atomicOperations == null) {
            this.atomicOperations = new LinkedList<AtomicOperation>();
            this.atomicOperations.offer(operation);
            try {
                while (!this.atomicOperations.isEmpty()) {
                    AtomicOperation atomicOperation = this.atomicOperations.poll();
                    atomicOperation.perform(this);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                this.atomicOperations = null;
            }
        } else {
            this.atomicOperations.offer(operation);
        }
    }

    @Override
    public void fire(String eventName, ObservableElement eventSource) {
        this.fire(eventName, eventSource, (ObservableElementImpl)eventSource);
    }

    void fire(String eventName, ObservableElement eventSource, ObservableElementImpl observableElement) {
        if (observableElement != null) {
            EventImpl event = observableElement.getEvent(eventName);
            if (event != null) {
                if (LOG.isTraceEnabled()) {
                    if (observableElement == eventSource) {
                        LOG.trace("firing " + event + " on " + eventSource);
                    } else {
                        LOG.trace("firing " + event + " on " + observableElement + ", propagated from source " + eventSource);
                    }
                }
                this.fire(event, eventSource, (ObservableElement)observableElement);
            }
            this.propagateEvent(eventName, eventSource, observableElement);
        }
    }

    protected void propagateEvent(String eventName, ObservableElement eventSource, ObservableElementImpl observableElement) {
        this.fire(eventName, eventSource, observableElement.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fire(EventImpl event, ObservableElement eventSource, ObservableElement observableElement) {
        try {
            this.event = event;
            this.eventSource = (ObservableElementImpl)eventSource;
            List<EventListenerReference> eventListenerReferences = event.getListenerReferences();
            if (eventListenerReferences != null) {
                for (EventListenerReference eventListenerReference : eventListenerReferences) {
                    if (!observableElement.equals(eventSource) && !eventListenerReference.isPropagationEnabled()) continue;
                    EventListener eventListener = (EventListener)eventListenerReference.get();
                    LOG.trace("executing " + eventListener + " for " + event);
                    try {
                        eventListener.notify(this);
                    }
                    catch (Exception e) {
                        LOG.trace("exception during action: " + e);
                        this.handleException((ObservableElementImpl)observableElement, event, eventListenerReference, e, "couldn't run action " + eventListener);
                    }
                }
            }
        }
        finally {
            this.eventSource = null;
            this.event = null;
        }
    }

    public void handleException(ObservableElementImpl observableElement, EventImpl event, EventListenerReference eventListenerReference, Exception exception, String rethrowMessage) {
        ArrayList<ProcessElementImpl> processElements = new ArrayList<ProcessElementImpl>();
        if (eventListenerReference != null) {
            processElements.add(eventListenerReference);
        }
        if (event != null) {
            processElements.add(event);
        }
        while (observableElement != null) {
            processElements.add(observableElement);
            observableElement = observableElement.getParent();
        }
        block3: for (ProcessElementImpl processElement : processElements) {
            List<ExceptionHandlerImpl> exceptionHandlers = processElement.getExceptionHandlers();
            if (exceptionHandlers == null) continue;
            for (ExceptionHandlerImpl exceptionHandler : exceptionHandlers) {
                if (!exceptionHandler.matches(exception)) continue;
                try {
                    exceptionHandler.handle(this, exception, processElement);
                    return;
                }
                catch (Exception rethrowException) {
                    if (exceptionHandler.isRethrowMasked()) continue block3;
                    exception = rethrowException;
                    continue block3;
                }
            }
        }
        LOG.trace("rethrowing exception cause no exception handler for " + exception);
        ExceptionHandlerImpl.rethrow(exception, rethrowMessage + ": " + exception.getMessage());
    }

    EventImpl findEvent(String eventName, ObservableElementImpl observableElement) {
        EventImpl event = null;
        while (event == null && observableElement != null) {
            event = observableElement.getEvent(eventName);
            if (event != null) continue;
            observableElement = observableElement.getParent();
        }
        return event;
    }

    @Override
    public Comment createComment(String message) {
        if (message == null) {
            throw new PvmException("message is null");
        }
        CommentImpl comment = new CommentImpl(message);
        this.addComment(comment);
        return comment;
    }

    @Override
    public void removeComment(Comment comment) {
        throw new UnsupportedOperationException("please implement me");
    }

    public void addComment(CommentImpl comment) {
        if (comment == null) {
            throw new PvmException("comment is null");
        }
        if (this.comments == null) {
            this.comments = new LinkedHashSet<CommentImpl>();
        }
        this.comments.add(comment);
    }

    @Override
    public ExecutionImpl createExecution() {
        return this.createExecution((String)null);
    }

    @Override
    public Execution createExecution(Execution parent) {
        return ((ExecutionImpl)parent).createExecution();
    }

    @Override
    public Execution createExecution(String name, Execution parent) {
        return ((ExecutionImpl)parent).createExecution(name);
    }

    @Override
    public ExecutionImpl createExecution(String name) {
        if (this.isActive()) {
            this.lock("inactive");
            this.propagation = Propagation.EXPLICIT;
        }
        ExecutionImpl childExecution = this.newChildExecution();
        childExecution.processDefinition = this.processDefinition;
        childExecution.processInstance = this.processInstance;
        childExecution.node = this.node;
        childExecution.state = "active";
        childExecution.name = name;
        LOG.debug("creating " + childExecution);
        this.addExecution(childExecution);
        this.executionsMap = null;
        IdGenerator keyGenerator = Environment.getFromCurrent(IdGenerator.class, false);
        if (keyGenerator != null) {
            childExecution.id = keyGenerator.createId(this.processDefinition, this, childExecution);
        }
        return childExecution;
    }

    protected ExecutionImpl newChildExecution() {
        return new ExecutionImpl();
    }

    public void addExecution(Execution execution) {
        ExecutionImpl executionImpl = (ExecutionImpl)execution;
        executionImpl.parent = this;
        if (this.executions == null) {
            this.executions = new ArrayList<ExecutionImpl>();
        }
        this.executions.add(executionImpl);
    }

    @Override
    public ExecutionImpl getExecution(String name) {
        Map<String, OpenExecution> executionsMap = this.getExecutionsMap();
        return (ExecutionImpl)(executionsMap != null ? executionsMap.get(name) : null);
    }

    @Override
    public void removeExecution(Execution child) {
        if (this.executions != null) {
            if (this.executions.remove(child)) {
                if (this.state.equals("inactive") && this.executions.isEmpty()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("last child execution was removed; unlocking");
                    }
                    this.state = "active";
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("removed " + child + " from " + this);
                }
                this.executionsMap = null;
            } else {
                throw new PvmException(child + " is not a child execution of " + this);
            }
        }
    }

    @Override
    public void removeExecution(Execution child, Execution parent) {
        ((ExecutionImpl)parent).removeExecution(child);
    }

    @Override
    public Map<String, OpenExecution> getExecutionsMap() {
        if (this.executionsMap == null && this.executions != null) {
            this.executionsMap = new HashMap<String, OpenExecution>();
            for (ExecutionImpl execution : this.executions) {
                String executionName = execution.getName();
                if (this.executionsMap.containsKey(executionName)) continue;
                this.executionsMap.put(executionName, execution);
            }
        }
        return this.executionsMap;
    }

    @Override
    public boolean hasExecution(String name) {
        return this.getExecutionsMap() != null && this.executionsMap.containsKey(name);
    }

    @Override
    public ClientProcessInstance createSubProcessInstance(ClientProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public ClientProcessInstance createSubProcessInstance(ClientProcessDefinition processDefinition, String key) {
        if (this.subProcessInstance != null) {
            throw new PvmException(this.toString() + " already has a sub process instance: " + this.subProcessInstance);
        }
        this.subProcessInstance = (ExecutionImpl)processDefinition.createProcessInstance(key);
        this.subProcessInstance.setSuperProcessExecution(this);
        return this.subProcessInstance;
    }

    @Override
    public ClientProcessInstance beginSubProcessInstance(ClientProcessDefinition processDefinition) {
        return this.beginSubProcessInstance(processDefinition, null);
    }

    @Override
    public ClientProcessInstance beginSubProcessInstance(ClientProcessDefinition processDefinition, String key) {
        this.createSubProcessInstance(processDefinition, key);
        this.subProcessInstance.begin();
        return this.subProcessInstance;
    }

    @Override
    public String getNodeName() {
        if (this.node == null) {
            return null;
        }
        return this.node.getName();
    }

    @Override
    public void addLog(ProcessLog processLog) {
        LogSession logSession;
        Environment environment = Environment.getCurrent();
        if (environment != null && (logSession = environment.get(LogSession.class)) != null) {
            processLog.setExecution(this);
            processLog.setTime(Clock.getCurrentTime());
            logSession.add(processLog);
        }
    }

    public int nextLogIndex() {
        return this.nextLogIndex++;
    }

    protected TransitionImpl findTransition(String transitionName) {
        return this.node.findOutgoingTransition(transitionName);
    }

    protected TransitionImpl findDefaultTransition() {
        return this.node.findDefaultTransition();
    }

    @Override
    public <T> T getExtension(Class<T> extensionClass) {
        if (extensionClass == null) {
            throw new PvmException("extensionClass is null.  and this execution doesn't support extensions");
        }
        throw new PvmException("unsuppported extension " + extensionClass.getName());
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public List<Comment> getComments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Comment>(this.comments);
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    @Override
    public ObservableElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public Collection<OpenExecution> getExecutions() {
        return this.executions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExecutionImpl getParent() {
        return this.parent;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    public void setEvent(EventImpl event) {
        this.event = event;
    }

    public void setEventSource(ObservableElementImpl eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    @Override
    public Node getPreviousNode() {
        return this.previousNode;
    }

    @Override
    public Transition getPreviousTransition() {
        return this.previousTransition;
    }

    @Override
    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionImpl processInstance) {
        this.processInstance = processInstance;
    }

    public void setComments(Set<CommentImpl> comments) {
        this.comments = comments;
    }

    public NodeImpl getTransitionOrigin() {
        return this.transitionOrigin;
    }

    public void setTransitionOrigin(NodeImpl transitionOrigin) {
        this.transitionOrigin = transitionOrigin;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public ProcessModificationsImpl getProcessModifications() {
        return this.processModifications;
    }

    public void setProcessModifications(ProcessModificationsImpl processModifications) {
        this.processModifications = processModifications;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setExecutions(Collection<ExecutionImpl> executions) {
        this.executions = executions;
    }

    public void setParent(ExecutionImpl parent) {
        this.parent = parent;
    }

    public void setPreviousNode(Node previousNode) {
        this.previousNode = previousNode;
    }

    public void setPreviousTransition(Transition previousTransition) {
        this.previousTransition = previousTransition;
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ExecutionImpl getSuperProcessExecution() {
        return this.superProcessExecution;
    }

    public void setSuperProcessExecution(ExecutionImpl superProcessExecution) {
        this.superProcessExecution = superProcessExecution;
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public void setSubProcessInstance(ExecutionImpl subProcessExecution) {
        this.subProcessInstance = subProcessExecution;
    }

    @Override
    public NodeImpl getNode() {
        return this.node;
    }

    public void setNode(NodeImpl node) {
        this.node = node;
    }

    @Override
    public long getDbid() {
        return this.dbid;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Propagation {
        UNSPECIFIED,
        WAIT,
        EXPLICIT;

    }
}

