/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.xml;

import java.util.List;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.ow2.orchestra.pvm.internal.xml.Bindings;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class BindingParser
extends Parser {
    private static final Log LOG = Log.getLog(BindingParser.class.getName());

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement, "binding");
        if (elements != null) {
            for (Element bindingElement : elements) {
                String bindingClassName = XmlUtil.attribute(bindingElement, "class");
                LOG.trace("adding wire binding for " + bindingClassName);
                Binding binding = null;
                if (bindingClassName != null) {
                    try {
                        Class<?> bindingClass = ReflectUtil.loadClass(this.classLoader, bindingClassName);
                        binding = (Binding)bindingClass.newInstance();
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't instantiate binding " + bindingClassName, e);
                    }
                } else {
                    parse.addProblem("class is a required attribute in a binding " + XmlUtil.toString(bindingElement));
                }
                if (binding != null) {
                    Bindings bindings = parse.findObject(Bindings.class);
                    bindings.addBinding(binding);
                    continue;
                }
                LOG.info("WARNING: binding for " + bindingClassName + " could not be parsed. See parsing problems for more details.");
            }
        }
        return null;
    }
}

