/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Logger;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class PartnerLinkRuntime {
    private static Logger log = Logger.getLogger(PartnerLinkRuntime.class.getName());
    protected long dbid;
    protected ActivityInstanceUUID scopeActivityInstanceUUID;
    protected String name;
    protected PartnerLink partnerLinkDefinition;
    private Element partnerRoleEndPointReference;
    private Element myRoleEndPointReference;

    protected PartnerLinkRuntime() {
    }

    public PartnerLinkRuntime(PartnerLink partnerLinkDefinition, BpelExecution execution, ActivityInstanceUUID scopeActivityInstanceUUID) {
        this.scopeActivityInstanceUUID = scopeActivityInstanceUUID;
        this.name = partnerLinkDefinition.getName();
        this.partnerLinkDefinition = partnerLinkDefinition;
        if (partnerLinkDefinition.getMyRolePortTypeQName() != null) {
            this.initializeMyRole(execution);
        }
        if (partnerLinkDefinition.getPartnerRolePortTypeQName() != null) {
            this.initializePartnerRole(execution);
        }
    }

    public void initializePartnerRole(BpelExecution execution) {
        this.partnerRoleEndPointReference = this.partnerLinkDefinition.getDefaultPartnerRoleEndPointReference();
        if (this.partnerRoleEndPointReference != null) {
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.PARTNER_ROLE_INITIALIZED, this.partnerRoleEndPointReference));
        }
    }

    public void initializeMyRole(BpelExecution execution) {
        this.myRoleEndPointReference = this.partnerLinkDefinition.getDefaultMyRoleEndPointReference();
        if (this.myRoleEndPointReference != null) {
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), execution.getActivityInstanceUUID(), this.name, PartnerLinkUpdateType.MY_ROLE_INITIALIZED, this.myRoleEndPointReference));
        }
    }

    public Element getMyRoleEndPointReference() {
        return this.myRoleEndPointReference;
    }

    public void setMyRoleEndPointReference(Element myRoleEndPointReference) {
        this.myRoleEndPointReference = myRoleEndPointReference;
    }

    public Element getPartnerRoleEndPointReference() {
        return this.partnerRoleEndPointReference;
    }

    public void setPartnerRoleEndPointReference(Element partnerRoleEndPointReference, ActivityInstanceUUID activityInstanceUUID) {
        this.partnerRoleEndPointReference = partnerRoleEndPointReference;
        EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, PartnerLinkUpdateType.PARTNER_ROLE_UPDATED, this.partnerRoleEndPointReference));
    }

    public String getName() {
        return this.name;
    }

    public PartnerLink getPartnerLinkDefinition() {
        return this.partnerLinkDefinition;
    }

    public long getDbid() {
        return this.dbid;
    }
}

