/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.SignalExecUtil;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAssociateMessage
implements Command<BpelExecution> {
    protected OperationKey operationKey;
    protected MessageVariable incomingMessage;
    protected MessageCarrier messageCarrier;
    protected boolean lock;

    public AsyncAssociateMessage(OperationKey operationKey, MessageVariable incomingMessage, MessageCarrier messageCarrier, boolean lock) {
        this.operationKey = operationKey;
        this.incomingMessage = incomingMessage;
        this.messageCarrier = messageCarrier;
        this.lock = lock;
    }

    @Override
    public BpelExecution execute(Environment environment) {
        Repository repository = EnvTool.getRepository();
        BpelProcess bpelProcess = this.lock ? repository.lockProcess(this.operationKey.getProcessUUID()) : repository.getProcess(this.operationKey.getProcessUUID());
        PendingMessage pendingMessage = Receiver.storeIncomingMessage(this.incomingMessage, this.messageCarrier, this.operationKey);
        ExecElementToSignal newExecElt = Receiver.associatePendingMessage(pendingMessage, bpelProcess, this.operationKey);
        if (newExecElt != null) {
            SignalExecUtil.execute(environment, newExecElt.getBpelExecution(), newExecElt.getReceivingElement(), newExecElt.getPendingMessage());
        } else {
            Receiver.storePendingMessage(pendingMessage);
        }
        return newExecElt != null ? newExecElt.getBpelExecution() : null;
    }
}

