/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.impl.ReplierImpl;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.var.MessageVariable;

public class Receiver {
    private static Logger log = Logger.getLogger(Receiver.class.getName());

    protected Receiver() {
    }

    static ExecElementToSignal findMessageForExecution(BpelExecution execution) {
        if (execution == null || execution.isFinished()) {
            return null;
        }
        HashMap<OperationKey, ReceivingElement> receivingElements = new HashMap<OperationKey, ReceivingElement>();
        Activity activity = execution.getNode().getBehaviour();
        if (activity instanceof InboundMessageElement) {
            for (ReceivingElement receivingElement : ((InboundMessageElement)((Object)activity)).getReceivingElements()) {
                receivingElements.put(receivingElement.getOperationKey(), receivingElement);
            }
        }
        for (OperationKey operationKey : execution.getWaitingOperationKeys()) {
            ReceivingElement receivingElement = (ReceivingElement)receivingElements.get(operationKey);
            PendingMessage pendingMessage = Receiver.getMessageFromStoredMessage(execution, receivingElement);
            if (pendingMessage == null) continue;
            Receiver.removePendingMessage(pendingMessage);
            return new ExecElementToSignal(execution, receivingElement, pendingMessage);
        }
        return null;
    }

    static ExecElementToSignal associatePendingMessage(PendingMessage pendingMessage, BpelProcess bpelProcess, OperationKey operationKey) {
        ExecElementToSignal execElementToSignal = null;
        execElementToSignal = Receiver.getWaitingExecution(pendingMessage, operationKey);
        if (execElementToSignal != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Matching execution found for incoming msg: " + execElementToSignal.getBpelExecution());
            }
            return execElementToSignal;
        }
        InboundMessageElement startActivity = bpelProcess.getStartElement(operationKey);
        if (startActivity != null) {
            ExecElementToSignal receiveExecution;
            ReceivingElement startElement = null;
            for (ReceivingElement receivingElement : startActivity.getReceivingElements()) {
                if (!receivingElement.getOperationKey().equals(operationKey)) continue;
                startElement = receivingElement;
            }
            if (startElement == null) {
                throw new IllegalStateException("No start element found");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("found start node " + startElement + " for incoming msg");
            }
            if ((receiveExecution = Receiver.createNewInstance(pendingMessage, bpelProcess, startActivity, startElement)) == null) {
                throw new OrchestraRuntimeException("No waiting execution found !, process = " + bpelProcess.getQName());
            }
            return receiveExecution;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("no matching execution found for pending msg.");
        }
        return null;
    }

    private static ExecElementToSignal createNewInstance(PendingMessage pendingMessage, BpelProcess bpelProcess, InboundMessageElement startActivity, ReceivingElement startElement) {
        BpelExecution bpelExecution = (BpelExecution)bpelProcess.createProcessInstance();
        HashMap<String, Object> additionnalVariables = new HashMap<String, Object>();
        Scope processActivity = (Scope)bpelProcess.getInitial().getBehaviour();
        if (startElement.getVariable() != null) {
            Variable var = ((AbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(startElement.getVariable());
            Variable var1 = processActivity.getVariable(startElement.getVariable());
            if (var1.equals(var)) {
                additionnalVariables.put(startElement.getVariable(), pendingMessage.getMessage().duplicate());
            }
        } else {
            for (Copy copy : startElement.getInCopies()) {
                Variable var = ((AbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(copy.getTo().getVariable());
                Variable var1 = processActivity.getVariable(copy.getTo().getVariable());
                if (!var1.equals(var)) continue;
                additionnalVariables.put(copy.getTo().getVariable(), pendingMessage.getMessage().getPartValue(copy.getFrom().getPart()));
            }
        }
        if (!additionnalVariables.isEmpty()) {
            bpelExecution.createVariable("additionnalScopeVariables", additionnalVariables);
        }
        bpelExecution.begin();
        return Receiver.getStartElementExecution(bpelExecution, startElement, pendingMessage);
    }

    public static void addReplier(BpelExecution bpelExecution, ReceivingElement receivingElement, MessageCarrier messageCarrier) {
        if (messageCarrier != null) {
            String messageExchange = receivingElement.getMessageExchange();
            ReplierKey replierKey = new ReplierKey(receivingElement.getOperationKey(), messageExchange, bpelExecution.getCurrentScopeRuntime());
            Replier replier = Receiver.createReplier(replierKey);
            MessageCarrierRepository.addMessageCarrier(replierKey, messageCarrier);
            bpelExecution.addReplier(replier);
        }
    }

    private static ExecElementToSignal getWaitingExecution(PendingMessage pendingMessage, OperationKey operationKey) {
        MessageVariable incomingMessage = pendingMessage.getMessage();
        Collection<BpelExecution> waitingExecutions = EnvTool.getRepository().getWaitingExecutions(operationKey);
        if (waitingExecutions.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No waiting executions for Receiver: " + operationKey);
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Waiting executions for Receiver " + operationKey + ": " + waitingExecutions);
        }
        for (BpelExecution bpelExecution : waitingExecutions) {
            if (bpelExecution.isInstanceSuspended()) continue;
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)bpelExecution.getNode().getBehaviour());
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Receiving Element: " + receivingElement.getOperationKey() + " / OperationKey=" + operationKey);
                }
                if (!receivingElement.getOperationKey().equals(operationKey) || !Receiver.csMatch(incomingMessage, receivingElement, bpelExecution)) continue;
                ExecElementToSignal res = new ExecElementToSignal(bpelExecution, receivingElement, pendingMessage);
                return res;
            }
        }
        return null;
    }

    private static ExecElementToSignal getStartElementExecution(BpelExecution parent, ReceivingElement startElement, PendingMessage pendingMessage) {
        if (parent == null) {
            return null;
        }
        BpelExecution instance = parent.getProcessInstance();
        BpelProcess bpelProcess = instance.getProcessDefinition();
        Set<BpelExecution> waitingExec = instance.searchWaitingExecutions();
        if (log.isLoggable(Level.FINE)) {
            log.fine(Receiver.class + ".getStartElementExecution, execution = " + parent + " waiting=" + waitingExec);
        }
        ExecElementToSignal res = null;
        if (waitingExec != null) {
            for (BpelExecution child : waitingExec) {
                Activity activity = child.getNode().getBehaviour();
                if (!(activity instanceof InboundMessageElement) || !((InboundMessageElement)((Object)activity)).getReceivingElements().contains(startElement)) continue;
                if (bpelProcess.getCommonCorrelationSets() != null) {
                    for (CorrelationSet cs : bpelProcess.getCommonCorrelationSets()) {
                        ReceivingElementUtil.initiateCs(startElement, child, cs, pendingMessage.getMessage());
                    }
                }
                return new ExecElementToSignal(child, startElement, pendingMessage, true);
            }
        }
        return res;
    }

    static PendingMessage storeIncomingMessage(MessageVariable message, MessageCarrier messageCarrier, OperationKey operationKey) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Incoming msg: " + message);
        }
        PendingMessage pendingMessage = null;
        if (messageCarrier != null) {
            MessageCarrierRepository.addPendingMessageCarrier(messageCarrier);
            pendingMessage = new PendingMessage(message, messageCarrier.getUuid(), operationKey);
        } else {
            pendingMessage = new PendingMessage(message, null, operationKey);
        }
        return pendingMessage;
    }

    protected static void storePendingMessage(PendingMessage pendingMessage) {
        EnvTool.getRepository().storePendingMessage(pendingMessage);
    }

    static boolean csMatch(MessageVariable messageToAnalyse, ReceivingElement receivingElement, BpelExecution bpelExecution) {
        if (receivingElement.getCorrelations() == null) {
            return true;
        }
        for (Correlation correlation : receivingElement.getCorrelations()) {
            if (correlation.correlationOK(messageToAnalyse, receivingElement, bpelExecution)) continue;
            return false;
        }
        return true;
    }

    private static PendingMessage getMessageFromStoredMessage(BpelExecution bpelExecution, ReceivingElement receivingElement) {
        Collection<PendingMessage> pendingMessages = EnvTool.getRepository().getPendingMessages(receivingElement.getOperationKey());
        for (PendingMessage pendingMessage : pendingMessages) {
            MessageVariable message = pendingMessage.getMessage();
            if (!Receiver.csMatch(message, receivingElement, bpelExecution)) continue;
            return pendingMessage;
        }
        return null;
    }

    public static void removePendingMessage(PendingMessage pendingMessage) {
        EnvTool.getRepository().removePendingMessage(pendingMessage);
    }

    private static Replier createReplier(ReplierKey replierKey) {
        return new ReplierImpl(replierKey);
    }
}

