/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.wsdl.Definition;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherImpl
implements Publisher {
    private final Map<ProcessDefinitionUUID, Set<Definition>> wsdlDefinitions = new HashMap<ProcessDefinitionUUID, Set<Definition>>();
    private final Map<String, ProcessEndpoint> processEndpoints = new HashMap<String, ProcessEndpoint>();

    @Override
    public void publishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.log(Level.INFO, "Publishing services for Bpel process %s (%s).", bpelProcess.getUUID(), bpelProcess.getQName());
        this.wsdlDefinitions.put(bpelProcess.getUUID(), new HashSet<Definition>(bpelProcess.getWsdlInfos().getWsdlDefinitions()));
    }

    @Override
    public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.log(Level.INFO, "Unpublishing services for Bpel process %s (%s).", bpelProcess.getUUID(), bpelProcess.getQName());
        this.wsdlDefinitions.remove(bpelProcess.getUUID());
    }

    protected Set<OperationKey> getServiceOperationKeys(BpelProcess bpelProcess, NodeImpl node, Environment environment) {
        List<Node> children;
        HashSet<OperationKey> operationKeys = new HashSet<OperationKey>();
        Activity behaviour = node.getBehaviour();
        if (behaviour instanceof InboundMessageElement) {
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)behaviour);
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                OperationKey operationKey = receivingElement.getOperationKey();
                operationKeys.add(operationKey);
            }
        }
        if ((children = node.getNodes()) != null) {
            for (Node child : children) {
                operationKeys.addAll(this.getServiceOperationKeys(bpelProcess, (NodeImpl)child, environment));
            }
        }
        return operationKeys;
    }

    public Set<Definition> getWsdlDefinitions(ProcessDefinitionUUID processDefinitionUUID) {
        return this.wsdlDefinitions.get(processDefinitionUUID);
    }

    public void addProcessEndpoint(String endpoint, ProcessDefinitionUUID processDefinitionUUID, Map<String, Boolean> locks, Map<String, Boolean> isOneWay) {
        ProcessEndpoint processEndpoint = new ProcessEndpoint();
        processEndpoint.processDefinitionUUID = processDefinitionUUID;
        processEndpoint.locks = locks;
        processEndpoint.isOneWay = isOneWay;
        this.processEndpoints.put(endpoint, processEndpoint);
    }

    public void removeProcessEndpoint(String endpoint) {
        this.processEndpoints.remove(endpoint);
    }

    public ProcessEndpoint getProcessEndpoint(String endpoint) {
        return this.processEndpoints.get(endpoint);
    }

    public static class ProcessEndpoint {
        private ProcessDefinitionUUID processDefinitionUUID;
        private Map<String, Boolean> isOneWay;
        private Map<String, Boolean> locks;

        public boolean isLock(String operationName) {
            return this.locks.get(operationName);
        }

        public boolean isOneWay(String operationName) {
            return this.isOneWay.get(operationName);
        }

        public ProcessDefinitionUUID getProcessDefinitionUUID() {
            return this.processDefinitionUUID;
        }
    }
}

