/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.Record;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.AbstractUUID;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Querier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerierChainer
implements Querier {
    private static Logger log = Logger.getLogger(QuerierChainer.class.getName());
    private final List<Querier> queriers;

    private <E extends Record> void putRecordCollection(Map<AbstractUUID, E> map, Collection<E> recordCollection) {
        if (recordCollection != null) {
            for (Record record : recordCollection) {
                AbstractUUID uuid = null;
                if (record instanceof ActivityInstance) {
                    uuid = ((ActivityInstance)record).getUUID();
                } else if (record instanceof ActivityDefinition) {
                    uuid = ((ActivityDefinition)record).getUUID();
                }
                if (map.put(uuid, record) == null || !log.isLoggable(Level.WARNING)) continue;
                log.warning("Duplicated entry (same uuid:" + uuid + ") found keep only the newest");
            }
        }
    }

    public QuerierChainer(List<Querier> queriers) {
        this.queriers = queriers;
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID processUUID) {
        HashMap activityFullInstanceByUUIDMap = new HashMap();
        HashSet<ActivityFullInstance> activityInsts = new HashSet<ActivityFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(activityFullInstanceByUUIDMap, querier.findActivityInstances(processUUID));
        }
        activityInsts.addAll(activityFullInstanceByUUIDMap.values());
        return activityInsts;
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) {
        HashMap activityFullInstanceByUUIDMap = new HashMap();
        HashSet<ActivityFullInstance> activityInsts = new HashSet<ActivityFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(activityFullInstanceByUUIDMap, querier.findActivityInstances(processUUID, activityState));
        }
        activityInsts.addAll(activityFullInstanceByUUIDMap.values());
        return activityInsts;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances() {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        HashSet<ProcessFullInstance> processInsts = new HashSet<ProcessFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessInstances());
        }
        processInsts.addAll(processFullInstanceByUUIDMap.values());
        return processInsts;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        HashSet<ProcessFullInstance> processInsts = new HashSet<ProcessFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessInstances(processDefinitionUUID));
        }
        processInsts.addAll(processFullInstanceByUUIDMap.values());
        return processInsts;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        HashSet<ProcessFullInstance> processInsts = new HashSet<ProcessFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessInstances(processDefinitionUUID, processInstanceState));
        }
        processInsts.addAll(processFullInstanceByUUIDMap.values());
        return processInsts;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ActivityState processInstanceState) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        HashSet<ProcessFullInstance> processInsts = new HashSet<ProcessFullInstance>();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessInstances(processInstanceState));
        }
        processInsts.addAll(processFullInstanceByUUIDMap.values());
        return processInsts;
    }

    @Override
    public ProcessFullInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) {
        for (Querier querier : this.queriers) {
            ProcessFullInstance processFullInstance = querier.getProcessInstance(processInstanceUUID);
            if (processFullInstance == null) continue;
            return processFullInstance;
        }
        return null;
    }

    @Override
    public ActivityFullInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        for (Querier querier : this.queriers) {
            ActivityFullInstance activityFullInstance = querier.getActivityInstance(activityInstanceUUID);
            if (activityFullInstance == null) continue;
            return activityFullInstance;
        }
        return null;
    }

    @Override
    public ActivityFullDefinition getActivityDefinition(ActivityDefinitionUUID activtyDefinitionUUID) {
        for (Querier querier : this.queriers) {
            ActivityFullDefinition activityFullInstance = querier.getActivityDefinition(activtyDefinitionUUID);
            if (activityFullInstance == null) continue;
            return activityFullInstance;
        }
        return null;
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name, ProcessState state) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessDefinitions(name, state));
        }
        ArrayList<ProcessFullDefinition> processFullDefinitionList = new ArrayList<ProcessFullDefinition>();
        processFullDefinitionList.addAll(processFullInstanceByUUIDMap.values());
        Collections.sort(processFullDefinitionList, new DeploymentDateComparator());
        return processFullDefinitionList;
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessDefinitions(name));
        }
        ArrayList<ProcessFullDefinition> processFullDefinitionList = new ArrayList<ProcessFullDefinition>();
        processFullDefinitionList.addAll(processFullInstanceByUUIDMap.values());
        Collections.sort(processFullDefinitionList, new DeploymentDateComparator());
        return processFullDefinitionList;
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(ProcessState state) {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessDefinitions(state));
        }
        ArrayList<ProcessFullDefinition> processFullDefinitionList = new ArrayList<ProcessFullDefinition>();
        processFullDefinitionList.addAll(processFullInstanceByUUIDMap.values());
        Collections.sort(processFullDefinitionList, new DeploymentDateComparator());
        return processFullDefinitionList;
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions() {
        HashMap processFullInstanceByUUIDMap = new HashMap();
        for (Querier querier : this.queriers) {
            this.putRecordCollection(processFullInstanceByUUIDMap, querier.findProcessDefinitions());
        }
        ArrayList<ProcessFullDefinition> processFullDefinitionList = new ArrayList<ProcessFullDefinition>();
        processFullDefinitionList.addAll(processFullInstanceByUUIDMap.values());
        Collections.sort(processFullDefinitionList, new DeploymentDateComparator());
        return processFullDefinitionList;
    }

    @Override
    public ProcessFullDefinition getProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        for (Querier querier : this.queriers) {
            ProcessFullDefinition processFullInstance = querier.getProcessDefinition(processDefinitionUUID);
            if (processFullInstance == null) continue;
            return processFullInstance;
        }
        return null;
    }

    @Override
    public ProcessFullDefinition removeProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        for (Querier querier : this.queriers) {
            ProcessFullDefinition processFullDefinition = querier.removeProcessDefinition(processDefinitionUUID);
            if (processFullDefinition == null) continue;
            return processFullDefinition;
        }
        return null;
    }

    @Override
    public ProcessFullInstance removeProcessInstance(ProcessInstanceUUID processInstanceUUID) {
        for (Querier querier : this.queriers) {
            ProcessFullInstance processFullInstance = querier.removeProcessInstance(processInstanceUUID);
            if (processFullInstance == null) continue;
            return processFullInstance;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentDateComparator
    implements Comparator<ProcessFullDefinition>,
    Serializable {
        private static final long serialVersionUID = 2463131104245876514L;

        private DeploymentDateComparator() {
        }

        @Override
        public int compare(ProcessFullDefinition o1, ProcessFullDefinition o2) {
            long o2date;
            long o1date = o1.getDeployedDate() != null ? o1.getDeployedDate().getTime() : 0L;
            long l = o2date = o2.getDeployedDate() != null ? o2.getDeployedDate().getTime() : 0L;
            if (o1date == o2date) {
                return 0;
            }
            if (o1date < o2date) {
                return -1;
            }
            return 1;
        }
    }
}

