/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.job;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalInvokeJob
extends MessageImpl<Void> {
    private static final long serialVersionUID = 1796627705334254482L;
    protected MessageVariable responseMessage;
    protected String exceptionMessage;
    protected QName faultName;

    protected SignalInvokeJob() {
    }

    public SignalInvokeJob(MessageVariable responseMessage, Exception exception) {
        this.responseMessage = responseMessage != null ? responseMessage.duplicate() : null;
        this.exceptionMessage = null;
        if (exception != null) {
            if (exception instanceof FaultWithMessageVariable) {
                FaultWithMessageVariable fault = (FaultWithMessageVariable)exception;
                this.faultName = fault.getFaultName();
                this.responseMessage = fault.getFaultMessage();
            } else {
                StringWriter sw = new StringWriter();
                exception.printStackTrace(new PrintWriter(sw));
                this.exceptionMessage = sw.toString();
            }
        }
    }

    @Override
    public Void execute(Environment environment) {
        BpelExecution execution = (BpelExecution)this.getExecution();
        HashMap<String, Object> signalParams = new HashMap<String, Object>();
        if (this.faultName != null) {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_EXCEPTION", new FaultWithMessageVariable(this.faultName, this.responseMessage));
        } else if (this.exceptionMessage != null && !this.exceptionMessage.equals("")) {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_EXCEPTION", new OrchestraRuntimeException(this.exceptionMessage));
        } else {
            signalParams.put("SIGNAL_PARAMETER_RECEIVED_MSG", this.responseMessage);
        }
        execution.signal(signalParams);
        JobDbSession jobDbSession = environment.get(JobDbSession.class);
        jobDbSession.delete(this);
        return null;
    }
}

